/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import tools.dynamia.commons.BeanUtils;

public class ApplicableClass {
    public static final ApplicableClass[] ALL = new ApplicableClass[]{new ApplicableClass(null)};
    private Class targetClass;

    public static boolean isApplicable(Class<?> objectClass, ApplicableClass[] applicableClasses) {
        return ApplicableClass.isApplicable(objectClass, applicableClasses, false);
    }

    public static boolean isApplicable(Class<?> objectClass, ApplicableClass[] applicableClasses, boolean includeParents) {
        if (applicableClasses == ALL || applicableClasses == null) {
            return true;
        }
        for (ApplicableClass applicableClass : applicableClasses) {
            if (applicableClass.getTargetClass().equals(objectClass)) {
                return true;
            }
            if (!includeParents || !BeanUtils.isAssignable(objectClass, applicableClass.getTargetClass())) continue;
            return true;
        }
        return false;
    }

    public ApplicableClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public static ApplicableClass[] get(Class ... classes) {
        if (classes.length == 0) {
            return ALL;
        }
        ApplicableClass[] appClasses = new ApplicableClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            appClasses[i] = new ApplicableClass(classes[i]);
        }
        return appClasses;
    }
}

