/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import tools.dynamia.commons.Messages;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.commons.reflect.PropertyInfo;

public class BeanMessages {
    private static final Map<Class, Map<Locale, BeanMessages>> GLOBAL_CACHE = new ConcurrentHashMap<Class, Map<Locale, BeanMessages>>();
    private Class<?> beanClass;
    private Locale locale;
    private List<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
    private LoggingService logger = new SLF4JLoggingService(BeanMessages.class);
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public static BeanMessages get(Class clazz, Locale locale) {
        if (clazz == null) {
            return null;
        }
        Map subcache = GLOBAL_CACHE.computeIfAbsent(clazz, k -> new ConcurrentHashMap());
        BeanMessages msg = (BeanMessages)subcache.get(locale);
        if (msg == null) {
            msg = new BeanMessages(clazz, locale);
            subcache.put(locale, msg);
        }
        return msg;
    }

    public BeanMessages(Class<?> beanClass) {
        this(beanClass, Messages.getDefaultLocale());
    }

    public BeanMessages(Class<?> beanClass, Locale locale) {
        this.beanClass = beanClass;
        this.locale = locale;
        this.initBundles();
    }

    private void initBundles() {
        this.findBundle(this.beanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findBundle(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        try {
            ResourceBundle.Control nofallback = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);
            if (clazz != Object.class) {
                ResourceBundle bundle = ResourceBundle.getBundle(clazz.getName(), this.getLocale(), clazz.getClassLoader(), nofallback);
                this.bundles.add(bundle);
            }
        }
        catch (MissingResourceException e) {
            this.logger.debug("ResourceBundle not found for " + clazz);
        }
        finally {
            if (clazz.getSuperclass() != null) {
                this.findBundle(clazz.getSuperclass());
            }
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalizedName() {
        String localizedName;
        String simpleName = this.beanClass.getSimpleName();
        if (simpleName.equals(localizedName = this.getMessage(simpleName))) {
            localizedName = StringUtils.addSpaceBetweenWords(simpleName);
        }
        return localizedName;
    }

    public String getMessage(PropertyInfo propertyInfo) {
        return this.getMessage(propertyInfo.getName());
    }

    public String getMessage(PropertyInfo propertyInfo, Object ... params) {
        return this.getMessage(propertyInfo.getName(), params);
    }

    public String getMessage(String propertyName) {
        return this.getMessage(propertyName, (Object[])null);
    }

    public String getMessage(String propertyName, Object ... params) {
        if (propertyName == null) {
            return "";
        }
        String message = this.cache.get(propertyName);
        if (message == null) {
            for (ResourceBundle bundle : this.bundles) {
                if (!bundle.containsKey(propertyName)) continue;
                message = bundle.getString(propertyName);
                this.cache.put(propertyName, message);
                break;
            }
        }
        if (message == null) {
            message = propertyName;
        } else if (params != null && params.length > 0) {
            message = MessageFormat.format(message, params, this.locale);
        }
        return message;
    }
}

