/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import tools.dynamia.commons.DynamicComparator;

public class BeanSorter<T>
implements Serializable {
    private static final long serialVersionUID = 961854285707596973L;
    private DynamicComparator<T> comparator;
    private String oldColumn;
    private boolean oldAscending;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public BeanSorter() {
        this(null);
    }

    public BeanSorter(String defaultField) {
        this(defaultField, true);
    }

    public BeanSorter(String defaultField, boolean asc) {
        this.comparator = new DynamicComparator(defaultField);
        this.comparator.setAscending(asc);
    }

    public void setColumnName(String column) {
        this.oldColumn = this.comparator.getField();
        this.comparator.setField(column);
        this.propertyChangeSupport.firePropertyChange("columnName", this.oldColumn, column);
    }

    public String getColumnName() {
        return this.comparator.getField();
    }

    public void setAscending(boolean ascending) {
        this.oldAscending = this.comparator.isAscending();
        this.comparator.setAscending(ascending);
        this.propertyChangeSupport.firePropertyChange("ascending", this.oldAscending, ascending);
    }

    public boolean isAscending() {
        return this.comparator.isAscending();
    }

    public void sort(List<T> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        if (this.oldColumn == null) {
            this.oldColumn = "";
        }
        if (this.oldAscending != this.comparator.isAscending() || !this.oldColumn.equals(this.comparator.getField())) {
            Collections.sort(data, this.comparator);
            this.oldAscending = this.comparator.isAscending();
            this.oldColumn = this.comparator.getField();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

