/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import tools.dynamia.commons.BeanMap;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.commons.ValueWrapper;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.commons.reflect.AccessMode;
import tools.dynamia.commons.reflect.PropertyInfo;
import tools.dynamia.commons.reflect.ReflectionException;

public final class BeanUtils {
    private static final Map<Class, Class> WRAPPERS = new HashMap<Class, Class>();
    private static final LoggingService LOGGER = new SLF4JLoggingService(BeanUtils.class);

    public static Object getFieldValue(String fieldName, Object object) {
        Object value = null;
        try {
            Field field = BeanUtils.getField(object.getClass(), fieldName);
            field.setAccessible(true);
            value = field.get(object);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Cannot find field " + fieldName + " in " + object.getClass() + ". Returning null value");
        }
        catch (Exception e) {
            LOGGER.error(e);
        }
        return value;
    }

    public static void setFieldValue(PropertyInfo propertyInfo, Object object, Object value) {
        BeanUtils.setFieldValue(propertyInfo.getName(), object, value);
    }

    public static void setFieldValue(String fieldName, Object object, Object value) {
        try {
            Field field = BeanUtils.getField(object.getClass(), fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            LOGGER.error(e);
        }
    }

    private BeanUtils() {
        throw new IllegalAccessError("Hey this is private");
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> T newInstance(String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (T)BeanUtils.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
    }

    public static Object invokeMethod(Object bean, String methodName, Object ... args) {
        Object value = null;
        if (bean != null && methodName != null) {
            try {
                Method method = null;
                if (args != null && args.length > 0) {
                    Class[] argClass = new Class[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        argClass[i] = args[i].getClass();
                    }
                    method = bean.getClass().getMethod(methodName, argClass);
                    method.setAccessible(true);
                    value = method.invoke(bean, args);
                } else {
                    method = bean.getClass().getMethod(methodName, new Class[0]);
                    method.setAccessible(true);
                    value = method.invoke(bean, new Object[0]);
                }
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
        return value;
    }

    public static Object invokeGetMethod(Object bean, String propertyName) {
        Object result = null;
        if (bean instanceof BeanMap) {
            result = ((BeanMap)bean).get(propertyName);
        } else if (propertyName.contains(".")) {
            int dotIndex = propertyName.indexOf(46);
            String subProperty = propertyName.substring(0, dotIndex);
            Object subBean = BeanUtils.invokeMethod(bean, BeanUtils.formatGetMethod(subProperty), new Object[0]);
            String rest = propertyName.substring(dotIndex + 1, propertyName.length());
            result = BeanUtils.invokeGetMethod(subBean, rest);
        } else {
            result = BeanUtils.invokeMethod(bean, BeanUtils.formatGetMethod(propertyName), new Object[0]);
        }
        return result;
    }

    public static Object invokeBooleanGetMethod(Object bean, String propertyName) {
        Object result = null;
        if (propertyName.contains(".")) {
            int dotIndex = propertyName.indexOf(46);
            String subProperty = propertyName.substring(0, dotIndex);
            Object subBean = BeanUtils.invokeMethod(bean, BeanUtils.formatGetMethod(subProperty), new Object[0]);
            String rest = propertyName.substring(dotIndex + 1, propertyName.length());
            result = BeanUtils.invokeGetMethod(subBean, rest);
        } else {
            result = BeanUtils.invokeMethod(bean, BeanUtils.formatBooleanGetMethod(propertyName), new Object[0]);
        }
        return result;
    }

    public static Object invokeGetMethod(Object bean, PropertyInfo property) {
        if (bean instanceof BeanMap) {
            return ((BeanMap)bean).get(property.getName());
        }
        if (property.is(Boolean.TYPE)) {
            return BeanUtils.invokeBooleanGetMethod(bean, property.getName());
        }
        return BeanUtils.invokeGetMethod(bean, property.getName());
    }

    public static void invokeSetMethod(Object bean, String name, Object value) {
        if (bean instanceof BeanMap) {
            ((BeanMap)bean).set(name, value);
            return;
        }
        String realName = name;
        Object realBean = bean;
        if (name.contains(".")) {
            String path = name.substring(0, name.lastIndexOf(46));
            realBean = BeanUtils.invokeGetMethod(bean, path);
            realName = name.substring(name.lastIndexOf(46) + 1);
        }
        String methodName = BeanUtils.formatSetMethod(realName);
        Class<?> beanClass = realBean.getClass();
        Class<?> valueClass = null;
        Object realValue = null;
        Method method = null;
        if (value instanceof ValueWrapper) {
            ValueWrapper valueWrapper = (ValueWrapper)value;
            valueClass = valueWrapper.getValueClass();
            realValue = valueWrapper.getValue();
        } else {
            valueClass = value.getClass();
            realValue = value;
        }
        try {
            method = beanClass.getMethod(methodName, valueClass);
        }
        catch (NoSuchMethodException e) {
            if (BeanUtils.isPrimitiveWrapper(valueClass)) {
                valueClass = BeanUtils.getWrappedPrimitiveType(valueClass);
                try {
                    method = beanClass.getMethod(methodName, valueClass);
                }
                catch (Exception e1) {
                    throw new ReflectionException(e1);
                }
            }
            try {
                method = beanClass.getMethod(methodName, valueClass.getSuperclass());
            }
            catch (Exception e1) {
                throw new ReflectionException(e1);
            }
        }
        if (method != null) {
            method.setAccessible(true);
            try {
                method.invoke(realBean, realValue);
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
    }

    public static void invokeSetMethod(Object bean, PropertyInfo property, Object value) {
        BeanUtils.invokeSetMethod(bean, property.getName(), value);
    }

    public static String formatGetMethod(String propertyName) {
        String getMethod = "get" + StringUtils.capitalize(propertyName);
        return getMethod;
    }

    public static String formatBooleanGetMethod(String propertyName) {
        String getMethod = "is" + StringUtils.capitalize(propertyName);
        return getMethod;
    }

    public static String formatSetMethod(String propertyName) {
        String setMethod = "set" + StringUtils.capitalize(propertyName);
        return setMethod;
    }

    public static Class getGenericTypeClass(Object classRef) {
        Type type;
        Class clazz = null;
        if (classRef != null && (type = classRef.getClass().getGenericSuperclass()) != null && type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return clazz;
    }

    public static Class getGenericTypeInterface(Object classRef, Class interfaceClass) {
        Class clazz = null;
        if (classRef != null) {
            Type[] types;
            for (Type type : types = classRef.getClass().getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type).getRawType().getTypeName().equals(interfaceClass.getName())) continue;
                clazz = (Class)parameterizedType.getActualTypeArguments()[0];
                break;
            }
        }
        return clazz;
    }

    public static Class<?> getFieldGenericType(Field field) {
        Class genericClass = null;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)genericType;
            genericClass = (Class)ptype.getActualTypeArguments()[0];
        }
        return genericClass;
    }

    public static Class<?> getMethodGenericType(Method getterMethod) {
        Type genericType;
        Class genericClass = null;
        if (getterMethod != null && (genericType = getterMethod.getGenericReturnType()) instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)genericType;
            genericClass = (Class)ptype.getActualTypeArguments()[0];
        }
        return genericClass;
    }

    public static Class<?> getFieldGenericType(Class clazz, String fieldName) throws NoSuchFieldException {
        Field field = BeanUtils.getField(clazz, fieldName);
        return BeanUtils.getFieldGenericType(field);
    }

    public static PropertyInfo getPropertyInfo(Class clazz, String propertyName) {
        PropertyInfo info;
        block4: {
            info = null;
            try {
                if (propertyName.contains(".")) {
                    String child = propertyName.substring(propertyName.indexOf(46) + 1);
                    String parent = propertyName.substring(0, propertyName.indexOf(46));
                    Class<?> parentClass = clazz.getMethod(BeanUtils.formatGetMethod(parent), new Class[0]).getReturnType();
                    info = BeanUtils.getPropertyInfo(parentClass, child);
                    break block4;
                }
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor prp : beanInfo.getPropertyDescriptors()) {
                    if (!prp.getName().equals(propertyName)) continue;
                    info = BeanUtils.getPropertyInfo(prp);
                    break;
                }
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
        return info;
    }

    private static PropertyInfo getPropertyInfo(PropertyDescriptor prop) {
        PropertyInfo info = null;
        String name = prop.getName();
        if (!name.equals("class")) {
            boolean writable;
            Class<?> type = prop.getPropertyType();
            Class<?> ownerClass = null;
            AccessMode accessMode = null;
            boolean readable = prop.getReadMethod() != null;
            boolean bl = writable = prop.getWriteMethod() != null;
            if (readable && writable) {
                accessMode = AccessMode.READ_WRITE;
            } else if (readable && !writable) {
                accessMode = AccessMode.READ_ONLY;
            } else if (!readable && writable) {
                accessMode = AccessMode.WRITE_ONLY;
            }
            ownerClass = readable ? prop.getReadMethod().getDeclaringClass() : prop.getWriteMethod().getDeclaringClass();
            info = new PropertyInfo(name, type, ownerClass, accessMode);
            try {
                info.setGenericType(BeanUtils.getMethodGenericType(prop.getReadMethod()));
            }
            catch (Exception e) {
                info.setGenericType(null);
            }
            if (BeanUtils.isAssignable(type, Collection.class)) {
                info.setCollection(true);
            }
        }
        return info;
    }

    public static List<PropertyInfo> getPropertiesInfo(Class clazz) {
        ArrayList<PropertyInfo> infos = new ArrayList<PropertyInfo>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                PropertyInfo pi = BeanUtils.getPropertyInfo(descriptor);
                if (pi == null) continue;
                infos.add(pi);
            }
        }
        catch (IntrospectionException e1) {
            throw new ReflectionException(e1);
        }
        return infos;
    }

    public static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        Field field = null;
        try {
            if (fieldName.contains(".")) {
                String childField = fieldName.substring(fieldName.indexOf(46) + 1);
                String parentField = fieldName.substring(0, fieldName.indexOf(46));
                Class<?> parentFieldClazz = clazz.getDeclaredField(parentField).getType();
                field = BeanUtils.getField(parentFieldClazz, childField);
            } else {
                field = clazz.getDeclaredField(fieldName);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw noSuchFieldException;
            }
            field = BeanUtils.getField(superClass, fieldName);
        }
        return field;
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            allFields.addAll(0, BeanUtils.getAllFields(clazz.getSuperclass()));
        }
        return allFields;
    }

    public static void setupBean(Object bean, Map<String, Object> values) {
        if (bean != null && values != null) {
            for (String key : values.keySet()) {
                try {
                    BeanUtils.invokeSetMethod(bean, key, values.get(key));
                }
                catch (Exception e) {
                    LOGGER.debug("WARN: Setting up bean " + e.getMessage());
                }
            }
        }
    }

    public static boolean isAssignable(Class a, Class b) {
        boolean assignable = false;
        if (a != null && b != null) {
            assignable = b.isAssignableFrom(a);
        }
        return assignable;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return WRAPPERS.containsValue(clazz);
    }

    public static Class<?> getPrimitiveWrapperType(Class<?> primitiveClass) {
        return WRAPPERS.get(primitiveClass);
    }

    public static Class<?> getWrappedPrimitiveType(Class<?> wrapperClass) {
        Class type = null;
        if (WRAPPERS.containsValue(wrapperClass)) {
            for (Map.Entry<Class, Class> entry : WRAPPERS.entrySet()) {
                if (!entry.getValue().equals(wrapperClass)) continue;
                type = entry.getKey();
            }
        }
        return type;
    }

    public static <T> List<T> findServiceProviders(Class<T> serviceClass) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceClass);
            for (T t : serviceLoader) {
                services.add(t);
            }
        }
        catch (ServiceConfigurationError e) {
            LOGGER.error(e);
        }
        return services;
    }

    public static boolean isAnnotated(Class annotationClass, Class targetClass) {
        Object annotation = targetClass.getAnnotation(annotationClass);
        return annotation != null;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : targetClass.getMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods.toArray(new Method[0]);
    }

    public static Field[] getFieldsWithAnnotation(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : targetClass.getFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields.toArray(new Field[0]);
    }

    public static Map<String, Object> getValuesMaps(String prefix, Object bean) {
        return BeanUtils.getValuesMaps(prefix, bean, null);
    }

    public static Map<String, Object> getValuesMaps(String prefix, Object bean, Object defaultValue) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (bean != null) {
            if (bean instanceof BeanMap) {
                values.putAll((Map)bean);
            } else {
                BeanUtils.getPropertiesInfo(bean.getClass()).stream().filter(p -> p.isStandardClass() && !p.isArray() && !p.isCollection()).forEach(p -> {
                    try {
                        Object value = BeanUtils.invokeGetMethod(bean, p);
                        if (value == null) {
                            value = defaultValue;
                        }
                        values.put(prefix + p.getName(), value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        } else {
            LOGGER.warn("Cannot get values map from bean because is null, returning empty map");
        }
        return values;
    }

    public static <T> T clone(T source, String ... excludedProperties) {
        Class<?> sourceClass = source.getClass();
        Object clon = BeanUtils.newInstance(sourceClass);
        Map<String, Object> values = BeanUtils.getValuesMaps("", source);
        if (excludedProperties != null) {
            for (String property : excludedProperties) {
                values.remove(property);
            }
        }
        BeanUtils.setupBean(clon, values);
        return (T)clon;
    }

    public static void setupBean(Object bean, Object source) {
        Map<String, Object> values = BeanUtils.getValuesMaps("", source);
        BeanUtils.setupBean(bean, values);
    }

    public static BeanMap newBeanMap(Object bean) {
        BeanMap beanMap = new BeanMap();
        beanMap.load(bean);
        return beanMap;
    }

    public static String findParentPropertyName(Class<?> parentClass, Class subentityClass) {
        List<PropertyInfo> infos = BeanUtils.getPropertiesInfo(subentityClass);
        for (PropertyInfo propertyInfo : infos) {
            if (!BeanUtils.isAssignable(propertyInfo.getType(), parentClass)) continue;
            return propertyInfo.getName();
        }
        return StringUtils.uncapitalize(parentClass.getSimpleName());
    }

    static {
        WRAPPERS.put(Byte.TYPE, Byte.class);
        WRAPPERS.put(Short.TYPE, Short.class);
        WRAPPERS.put(Character.TYPE, Character.class);
        WRAPPERS.put(Integer.TYPE, Integer.class);
        WRAPPERS.put(Long.TYPE, Long.class);
        WRAPPERS.put(Float.TYPE, Float.class);
        WRAPPERS.put(Double.TYPE, Double.class);
        WRAPPERS.put(Boolean.TYPE, Boolean.class);
    }
}

