/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tools.dynamia.commons.BeanUtils;

public class BigDecimalUtils {
    public static BigDecimal sum(String field, List data) {
        BigDecimal total = BigDecimal.ZERO;
        try {
            if (data != null && !data.isEmpty()) {
                for (Object object : data) {
                    Object value = BeanUtils.invokeGetMethod(object, field);
                    if (!(value instanceof Number)) continue;
                    if (value instanceof BigDecimal) {
                        total = total.add((BigDecimal)value);
                        continue;
                    }
                    total = total.add(BigDecimal.valueOf(((Number)value).doubleValue()));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return total;
    }

    public static boolean gt(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.safe(a)).compareTo(b = BigDecimalUtils.safe(b)) > 0;
    }

    public static boolean gte(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.safe(a)).compareTo(b = BigDecimalUtils.safe(b)) >= 0;
    }

    public static boolean lt(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.safe(a)).compareTo(b = BigDecimalUtils.safe(b)) < 0;
    }

    public static boolean lte(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.safe(a)).compareTo(b = BigDecimalUtils.safe(b)) <= 0;
    }

    public static boolean isNegative(BigDecimal a) {
        return BigDecimalUtils.lt(a, BigDecimal.ZERO);
    }

    public static boolean isPositive(BigDecimal a) {
        return BigDecimalUtils.gt(a, BigDecimal.ZERO);
    }

    public static BigDecimal safe(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public static BigDecimal evaluate(String mathExpression, Map<String, Number> vars) throws ScriptException {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine script = mgr.getEngineByName("JavaScript");
        for (Map.Entry<String, Number> entry : vars.entrySet()) {
            script.put(entry.getKey(), entry.getValue());
        }
        Number result = (Number)script.eval(mathExpression);
        return new BigDecimal(result.toString());
    }

    public static BigDecimal addPercent(BigDecimal value, double percent) {
        return value.add(BigDecimalUtils.computePercent(value, percent, false));
    }

    public static BigDecimal computePercent(BigDecimal value, double percent, boolean included) {
        BigDecimal p100 = new BigDecimal(percent / 100.0);
        if (included) {
            return value.subtract(value.divide(p100.add(BigDecimal.ONE), MathContext.DECIMAL32), MathContext.DECIMAL32);
        }
        return value.multiply(p100, MathContext.DECIMAL32);
    }

    public static double rate(long numberPeriods, BigDecimal paymentByPeriod, BigDecimal total) {
        return BigDecimalUtils.rate((double)numberPeriods, paymentByPeriod.doubleValue(), total.doubleValue());
    }

    public static double rate(double numberPeriods, double paymentByPeriod, double totalValue) {
        double error = 1.0E-7;
        double high = 1.0;
        double low = 0.0;
        double rate = 2.0 * (numberPeriods * paymentByPeriod - totalValue) / (totalValue * numberPeriods);
        while (true) {
            double calc = Math.pow(1.0 + rate, numberPeriods);
            calc = rate * calc / (calc - 1.0);
            if ((calc -= paymentByPeriod / totalValue) > error) {
                high = rate;
                rate = (high + low) / 2.0;
                continue;
            }
            if (!(calc < -error)) break;
            low = rate;
            rate = (high + low) / 2.0;
        }
        return rate;
    }

    private BigDecimalUtils() {
    }
}

