/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.io.Serializable;
import java.util.Date;
import tools.dynamia.commons.DateRange;
import tools.dynamia.commons.DateTimeUtils;

public class DateInfo
implements Serializable {
    private int year;
    private int month;
    private int day;

    public DateInfo() {
    }

    public DateInfo(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public int getYear() {
        return this.year;
    }

    public final void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public final void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public final void setDay(int day) {
        this.day = day;
    }

    public Date toDate() {
        return DateTimeUtils.createDate(this.year, this.month, this.day);
    }

    public DateRange toRange() {
        Date start = null;
        Date end = null;
        if (this.isFullDate()) {
            start = DateTimeUtils.createDate(this.year, this.month, this.day, 0, 0);
            end = DateTimeUtils.createDate(this.year, this.month, this.day + 1, 0, 0);
        } else if (this.isMonth()) {
            start = DateTimeUtils.createDate(this.year, this.month, 1);
            end = DateTimeUtils.createDate(this.year, this.month, DateTimeUtils.getLastDayOfMonth(this.month));
        } else {
            start = DateTimeUtils.createDate(this.year, 1, 1);
            end = DateTimeUtils.createDate(this.year, 12, 31);
        }
        return new DateRange(start, end);
    }

    public boolean isYear() {
        return this.year > 0 && this.month == 0 && this.day == 0;
    }

    public boolean isMonth() {
        return this.year > 0 && this.month > 0 && this.day == 0;
    }

    public boolean isFullDate() {
        return this.year > 0 && this.month > 0 && this.day > 0;
    }
}

