/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import tools.dynamia.commons.DateTimeUtils;

public class DateRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date endDate;
    private Date startDate;

    public DateRange() {
    }

    public DateRange(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public long getDaysBetween() {
        return DateTimeUtils.daysBetween(this.startDate, this.endDate);
    }

    public long getHoursBetween() {
        return DateTimeUtils.hoursBetween(this.startDate, this.endDate);
    }

    public long getMinutesBetween() {
        return DateTimeUtils.minutesBetween(this.startDate, this.endDate);
    }

    public long getSecondsBetween() {
        return DateTimeUtils.secondsBetween(this.startDate, this.endDate);
    }

    public long getMonthsBetween() {
        return DateTimeUtils.monthsBetween(this.startDate, this.endDate);
    }

    public long getYearsBetween() {
        return DateTimeUtils.yearsBetween(this.startDate, this.endDate);
    }

    List<Date> getDaysBetweenList() {
        ArrayList<Date> dates = new ArrayList<Date>();
        long days = this.getDaysBetween();
        int i = 0;
        while ((long)i < days) {
            dates.add(DateTimeUtils.addDays(this.startDate, i));
            ++i;
        }
        return dates;
    }

    public boolean isNull() {
        return this.endDate == null || this.startDate == null;
    }

    public String toString() {
        return String.valueOf(this.startDate) + "  /  " + String.valueOf(this.endDate);
    }
}

