/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import tools.dynamia.commons.DateRange;

public final class DateTimeUtils {
    public static final int SHORT = 3;
    public static final int MEDIUM = 2;
    public static final int LONG = 1;

    public static int getLastDayOfMonth(int month) {
        return DateTimeUtils.getLastDayOfMonth(Month.of(month));
    }

    public static int getLastDayOfMonth(Month month) {
        return month.length(LocalDate.now().isLeapYear());
    }

    private DateTimeUtils() {
    }

    public static boolean isFuture(Date date) {
        return date.after(new Date());
    }

    public static boolean isPast(Date date) {
        return date.before(new Date());
    }

    public static boolean isToday(Date date) {
        Date today = new Date();
        return DateTimeUtils.getYear(today) == DateTimeUtils.getYear(date) && DateTimeUtils.getMonth(today) == DateTimeUtils.getMonth(date) && DateTimeUtils.getDay(today) == DateTimeUtils.getDay(date);
    }

    public static int getCurrentYear() {
        return DateTimeUtils.getYear(new Date());
    }

    public static int getCurrentMonth() {
        return DateTimeUtils.getMonth(new Date());
    }

    public static String getCurrentMonthName() {
        SimpleDateFormat df = new SimpleDateFormat("MMMM");
        return df.format(new Date());
    }

    public static int getCurrentDay() {
        return DateTimeUtils.getDay(new Date());
    }

    public static long millisBetween(Date date1, Date date2) {
        LocalDate localDate1 = DateTimeUtils.toLocalDate(date1);
        LocalDate localDate2 = DateTimeUtils.toLocalDate(date2);
        return localDate1.until(localDate2, ChronoUnit.MILLIS);
    }

    public static long yearsBetween(Date date1, Date date2) {
        LocalDate localDate1 = DateTimeUtils.toLocalDate(date1);
        LocalDate localDate2 = DateTimeUtils.toLocalDate(date2);
        return localDate1.until(localDate2, ChronoUnit.YEARS);
    }

    public static long monthsBetween(Date date1, Date date2) {
        LocalDate localDate1 = DateTimeUtils.toLocalDate(date1);
        LocalDate localDate2 = DateTimeUtils.toLocalDate(date2);
        return localDate1.until(localDate2, ChronoUnit.MONTHS);
    }

    public static long daysBetween(Date date1, Date date2) {
        return DateTimeUtils.toInstant(date1).until(DateTimeUtils.toInstant(date2), ChronoUnit.DAYS);
    }

    public static long hoursBetween(Date date1, Date date2) {
        return DateTimeUtils.toInstant(date1).until(DateTimeUtils.toInstant(date2), ChronoUnit.HOURS);
    }

    public static long minutesBetween(Date date1, Date date2) {
        return DateTimeUtils.toInstant(date1).until(DateTimeUtils.toInstant(date2), ChronoUnit.MINUTES);
    }

    public static long secondsBetween(Date date1, Date date2) {
        return DateTimeUtils.toInstant(date1).until(DateTimeUtils.toInstant(date2), ChronoUnit.SECONDS);
    }

    public static Date createDate(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        return calendar.getTime();
    }

    public static Date createDate(int dayOfMonth) {
        return DateTimeUtils.toDate(LocalDate.now().withDayOfMonth(dayOfMonth));
    }

    public static Date createDate(int year, int month, int day) {
        return DateTimeUtils.toDate(LocalDate.of(year, month, day));
    }

    public static Date createDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        return DateTimeUtils.toDate(LocalDateTime.of(year, month, day, hourOfDay, minute, second));
    }

    public static Date createDate(int year, int month, int day, int hourOfDay, int minute) {
        return DateTimeUtils.toDate(LocalDateTime.of(year, month, day, hourOfDay, minute));
    }

    public static Date createDate(String dateText) throws ParseException {
        DateFormat df = DateFormat.getDateInstance();
        return df.parse(dateText);
    }

    public static Date createDate(String dateText, String pattern) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.parse(dateText);
    }

    public static Date addDays(Date date, int days) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(date).plusDays(days));
    }

    public static Date addMonths(Date date, int months) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(date).plusMonths(months));
    }

    public static Date addYears(Date date, int years) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(date).plusYears(years));
    }

    public static Date addWeeks(Date date, int weeks) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(date).plusWeeks(weeks));
    }

    public static Date addHours(Date date, int hours) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(date).plus(hours, ChronoUnit.HOURS));
    }

    public static Date addMinutes(Date date, int minutes) {
        return DateTimeUtils.toDate(DateTimeUtils.toLocalDateTime(date).plus(minutes, ChronoUnit.MINUTES));
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static String formatDate(Date date, int style) {
        DateFormat df = DateFormat.getDateInstance(style);
        return df.format(date);
    }

    public static String formatDate(Date date) {
        return DateTimeUtils.formatDate(date, 2);
    }

    public static String formatTime(Date date, int style) {
        DateFormat df = DateFormat.getTimeInstance(style);
        return df.format(date);
    }

    public static String formatTime(Date date) {
        return DateTimeUtils.formatTime(date, 2);
    }

    public static int getMonth(Date date) {
        return DateTimeUtils.toLocalDate(date).getMonth().getValue();
    }

    public static int getDay(Date date) {
        return DateTimeUtils.toLocalDate(date).getDayOfMonth();
    }

    public static int getYear(Date date) {
        return DateTimeUtils.toLocalDate(date).getYear();
    }

    public static Date tomorrow() {
        return DateTimeUtils.addDays(DateTimeUtils.now(), 1);
    }

    public static Date now() {
        return new Date();
    }

    public static Date yesterday() {
        return DateTimeUtils.addDays(DateTimeUtils.now(), -1);
    }

    public static Date dayAfterTomorrow() {
        return DateTimeUtils.addDays(DateTimeUtils.tomorrow(), 1);
    }

    public static LocalDate toLocalDate(Date input) {
        if (input instanceof java.sql.Date) {
            return ((java.sql.Date)input).toLocalDate();
        }
        Instant instant = input.toInstant();
        ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
        return zdt.toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date input) {
        Instant instant = null;
        instant = input instanceof java.sql.Date ? Instant.ofEpochMilli(input.getTime()) : input.toInstant();
        ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
        return zdt.toLocalDateTime();
    }

    public static Instant toInstant(Date input) {
        if (input instanceof java.sql.Date) {
            LocalDate localDate = ((java.sql.Date)input).toLocalDate();
            Instant instant = null;
            try {
                instant = Instant.from(localDate);
            }
            catch (DateTimeException e) {
                instant = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
            }
            return instant;
        }
        return input.toInstant();
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getEndOfDay(Date date) {
        return Date.from(DateTimeUtils.toLocalDate(date).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(Date date) {
        return Date.from(DateTimeUtils.toLocalDate(date).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static DateRange getCurrentMonthRange() {
        Date startDate = DateTimeUtils.createDate(DateTimeUtils.getCurrentYear(), DateTimeUtils.getCurrentMonth(), 1);
        Date endDate = DateTimeUtils.createDate(DateTimeUtils.getCurrentYear(), DateTimeUtils.getCurrentMonth(), DateTimeUtils.getLastDayOfMonth(DateTimeUtils.getCurrentMonth()));
        return new DateRange(startDate, endDate);
    }
}

