/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tools.dynamia.commons.Messages;

public enum DayOfWeek {
    SUNDAY("SUN", 1),
    MONDAY("MON", 2),
    TUESDAY("TUE", 3),
    WEDNESDAY("WED", 4),
    THURSDAY("THU", 5),
    FRIDAY("FRI", 6),
    SATURDAY("SAT", 7);

    private String cronName;
    private int number;

    private DayOfWeek(String cronName, int number) {
        this.cronName = cronName;
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public String getCronName() {
        return this.cronName;
    }

    public String getDisplayName(Locale locale) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, this.number);
        SimpleDateFormat format = new SimpleDateFormat("EEEE", locale);
        return format.format(cal.getTime()).toUpperCase();
    }

    public String getDisplayName() {
        return this.getDisplayName(Messages.getDefaultLocale());
    }

    public static DayOfWeek today() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(7);
        return DayOfWeek.of(day);
    }

    public static DayOfWeek of(int day) {
        return DayOfWeek.values()[day - 1];
    }

    public static List<DayOfWeek> valuesList() {
        return Stream.of(DayOfWeek.values()).collect(Collectors.toList());
    }

    public String toString() {
        return this.getDisplayName();
    }
}

