/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.util.Comparator;
import tools.dynamia.commons.BeanUtils;

public class DynamicComparator<T>
implements Comparator<T> {
    private String field;
    private boolean ascending;

    public DynamicComparator() {
        this(null);
    }

    public DynamicComparator(String field) {
        this.setField(field);
    }

    public DynamicComparator(String field, boolean ascending) {
        this.field = field;
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        if (field != null && field.isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be empty ");
        }
        this.field = field;
    }

    @Override
    public int compare(T o1, T o2) {
        int result = 0;
        Comparable value1 = this.getValue(o1);
        Comparable value2 = this.getValue(o2);
        result = value1 != null && value2 == null ? 1 : (value1 == null && value2 != null ? -1 : (value1 == null && value2 == null ? 0 : value1.compareTo(value2)));
        if (!this.isAscending()) {
            if (result < 0) {
                result = 1;
            } else if (result > 0) {
                result = -1;
            }
        }
        return result;
    }

    private Comparable getValue(T obj) {
        Comparable value = null;
        if (obj != null && this.field != null) {
            try {
                Object result = BeanUtils.invokeGetMethod(obj, this.field);
                if (result instanceof Comparable) {
                    value = (Comparable)result;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return value;
    }
}

