/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import tools.dynamia.commons.LocaleProvider;

public class Messages {
    private static Supplier<Collection<LocaleProvider>> localeProviders;

    public static ResourceBundle getBundle(Class<?> clazz) {
        return Messages.getBundle(clazz, Messages.getDefaultLocale());
    }

    public static ResourceBundle getBundle(Class<?> clazz, Locale locale) {
        String baseName = clazz.getPackage().getName() + ".Messages";
        ResourceBundle.Control nofallback = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        return ResourceBundle.getBundle(baseName, locale, clazz.getClassLoader(), nofallback);
    }

    public static String get(Class<?> clazz, String key) {
        return Messages.get(clazz, Messages.getDefaultLocale(), key, new Object[0]);
    }

    public static String get(Class<?> clazz, Locale locale, String key) {
        return Messages.get(clazz, locale, key, new Object[0]);
    }

    public static String get(Class<?> clazz, String key, Object ... params) {
        return Messages.get(clazz, Messages.getDefaultLocale(), key, params);
    }

    public static String get(Class<?> clazz, Locale locale, String key, Object ... params) {
        if (key == null) {
            return "";
        }
        if (clazz == null) {
            return key;
        }
        String message = null;
        try {
            message = Messages.getBundle(clazz, locale).getString(key);
            if (params != null && params.length > 0) {
                message = Messages.format(message, params);
            }
        }
        catch (MissingResourceException e) {
            message = key;
        }
        return message;
    }

    public static String format(String message, Object ... params) {
        return MessageFormat.format(message, params);
    }

    public static Locale getDefaultLocale() {
        if (localeProviders == null) {
            return Locale.getDefault();
        }
        LocaleProvider localeProvider = localeProviders.get().stream().min(Comparator.comparing(LocaleProvider::getPriority)).orElse(null);
        if (localeProvider != null) {
            return localeProvider.getDefaultLocale();
        }
        return Locale.getDefault();
    }

    private Messages() {
    }

    public static void setLocaleProvidersSupplier(Supplier<Collection<LocaleProvider>> supplier) {
        localeProviders = supplier;
    }

    static {
        try {
            Files.readAllLines(Paths.get(Messages.class.getResource("/dynamia/banner.txt").toURI())).forEach(System.out::println);
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("DynamiaTools is Powered By: Dynamia Soluciones IT");
            System.out.println("http://www.dynamia.tools");
            System.out.println("http://www.dynamiasoluciones.com");
            System.out.println("----------------------------------------------------");
        }
    }
}

