/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class SimpleCache<K, V> {
    private Map<K, V> data = new ConcurrentHashMap();

    public void add(K key, V value) {
        this.data.put(key, value);
    }

    public V get(K key) {
        return this.data.get(key);
    }

    public V getOrLoad(K key, Function<K, V> loaderFunction) {
        V value = this.get(key);
        if (value == null && (value = loaderFunction.apply(key)) != null) {
            this.add(key, value);
        }
        return value;
    }

    public V remove(K key) {
        return this.data.remove(key);
    }

    public void clear() {
        this.data.clear();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }
}

