/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

public class SpanishNumberFormat {
    private static String[] _grupos = new String[]{"", "millon", "billon", "trillon"};
    private static String[] _unidades = new String[]{"", "un", "dos", "tres", "cuatro", "cinco", "seis", "siete", "ocho", "nueve"};
    private static String[] _decena1 = new String[]{"", "once", "doce", "trece", "catorce", "quince", "dieciseis", "diecisiete", "dieciocho", "diecinueve"};
    private static String[] _decenas = new String[]{"", "diez", "veinte", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa"};
    private static String[] _centenas = new String[]{"", "cien", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos"};

    public static String millarATexto(int n) {
        if (n == 0) {
            return "";
        }
        int centenas = n / 100;
        int decenas = (n %= 100) / 10;
        int unidades = n % 10;
        String sufijo = "";
        if (decenas == 0 && unidades != 0) {
            sufijo = _unidades[unidades];
        }
        if (decenas == 1 && unidades != 0) {
            sufijo = _decena1[unidades];
        }
        if (decenas == 2 && unidades != 0) {
            sufijo = "veinti" + _unidades[unidades];
        }
        if (unidades == 0) {
            sufijo = _decenas[decenas];
        }
        if (decenas > 2 && unidades != 0) {
            sufijo = _decenas[decenas] + " y " + _unidades[unidades];
        }
        if (centenas != 1) {
            return _centenas[centenas] + " " + sufijo;
        }
        if (unidades == 0 && decenas == 0) {
            return "cien";
        }
        return "ciento " + sufijo;
    }

    public static String convert(long n) {
        String resultado = "";
        for (int grupo = 0; n != 0L && grupo < _grupos.length; ++grupo) {
            long fragmento = n % 1000000L;
            int millarAlto = (int)(fragmento / 1000L);
            int millarBajo = (int)(fragmento % 1000L);
            n /= 1000000L;
            String nombreGrupo = _grupos[grupo];
            if (fragmento > 1L && grupo > 0) {
                nombreGrupo = nombreGrupo + "es";
            }
            if (millarAlto == 0 && millarBajo == 0) continue;
            if (millarAlto > 1) {
                resultado = SpanishNumberFormat.millarATexto(millarAlto) + " mil " + SpanishNumberFormat.millarATexto(millarBajo) + " " + nombreGrupo + " " + resultado;
            }
            if (millarAlto == 0) {
                resultado = SpanishNumberFormat.millarATexto(millarBajo) + " " + nombreGrupo + " " + resultado;
            }
            if (millarAlto != 1) continue;
            resultado = "mil " + SpanishNumberFormat.millarATexto(millarBajo) + " " + nombreGrupo + " " + resultado;
        }
        return resultado;
    }

    private SpanishNumberFormat() {
    }
}

