/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons;

import java.text.Normalizer;
import java.util.Map;
import java.util.regex.Pattern;
import tools.dynamia.commons.MapBuilder;

public class StringSimplifier {
    public static final char DEFAULT_REPLACE_CHAR = '-';
    public static final String DEFAULT_REPLACE = String.valueOf('-');
    private static final Map<String, String> NONDIACRITICS = new MapBuilder<String, String>().put(".", "").put("\"", "").put("'", "").put(" ", DEFAULT_REPLACE).put("]", DEFAULT_REPLACE).put("[", DEFAULT_REPLACE).put(")", DEFAULT_REPLACE).put("(", DEFAULT_REPLACE).put("=", DEFAULT_REPLACE).put("!", DEFAULT_REPLACE).put("/", DEFAULT_REPLACE).put("\\", DEFAULT_REPLACE).put("&", DEFAULT_REPLACE).put(",", DEFAULT_REPLACE).put("?", DEFAULT_REPLACE).put("\u00b0", DEFAULT_REPLACE).put("|", DEFAULT_REPLACE).put("<", DEFAULT_REPLACE).put(">", DEFAULT_REPLACE).put(";", DEFAULT_REPLACE).put(":", DEFAULT_REPLACE).put("_", DEFAULT_REPLACE).put("#", DEFAULT_REPLACE).put("~", DEFAULT_REPLACE).put("+", DEFAULT_REPLACE).put("*", DEFAULT_REPLACE).put("\u0141", "l").put("\u0142", "l").put("\u00df", "ss").put("\u00e6", "ae").put("\u00f8", "o").put("\u00a9", "c").put("\u00d0", "d").put("\u00f0", "d").put("\u0110", "d").put("\u0111", "d").put("\u0189", "d").put("\u0256", "d").put("\u00de", "th").put("\u00fe", "th").build();
    public static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

    public static String simplifiedString(String orig) {
        String str = orig;
        if (str == null) {
            return null;
        }
        str = StringSimplifier.stripDiacritics(str);
        if ((str = StringSimplifier.stripNonDiacritics(str)).length() == 0) {
            return orig;
        }
        return str.toLowerCase();
    }

    private static String stripNonDiacritics(String orig) {
        StringBuffer ret = new StringBuffer();
        String lastchar = null;
        for (int i = 0; i < orig.length(); ++i) {
            String toReplace;
            String source = orig.substring(i, i + 1);
            String replace = NONDIACRITICS.get(source);
            String string = toReplace = replace == null ? String.valueOf(source) : replace;
            if (DEFAULT_REPLACE.equals(lastchar) && DEFAULT_REPLACE.equals(toReplace)) {
                toReplace = "";
            } else {
                lastchar = toReplace;
            }
            ret.append(toReplace);
        }
        if (ret.length() > 0 && '-' == ret.charAt(ret.length() - 1)) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    private static String stripDiacritics(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }

    private StringSimplifier() {
    }
}

