/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons.collect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tools.dynamia.commons.collect.ListMultiMap;

public class ArrayListMultiMap<K, V>
implements ListMultiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 4476740655051507386L;
    private final Map<K, List<V>> delegate = new HashMap<K, List<V>>();

    @Override
    public List<V> get(K key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        ArrayList<Object> values = this.get((Object)key);
        if (values == null) {
            values = new ArrayList<Object>();
            this.delegate.put(key, values);
        }
        if (value instanceof Collection) {
            Collection newValues = (Collection)value;
            for (Object object : newValues) {
                values.add(object);
            }
        } else {
            values.add(value);
        }
        return value;
    }

    @Override
    public void put(K key, V value, V ... values) {
        this.put(key, value);
        for (V other : values) {
            this.put(key, other);
        }
    }

    @Override
    public void putAll(K key, Collection<V> newValues) {
        ArrayList<V> values = this.get((Object)key);
        if (values == null) {
            values = new ArrayList<V>();
            this.delegate.put(key, values);
        }
        values.addAll(newValues);
    }

    @Override
    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public List<V> remove(K key) {
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public K getKey(V value) {
        K key = null;
        for (Map.Entry<K, List<V>> entry : this.delegate.entrySet()) {
            if (!entry.getValue().contains(value)) continue;
            key = entry.getKey();
            break;
        }
        return key;
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }
}

