/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.commons.collect.CollectionWrapper;
import tools.dynamia.commons.reflect.PropertyInfo;
import tools.dynamia.commons.reflect.ReflectionException;

public class CollectionsUtils {
    public static Collection<CollectionWrapper> group(Collection collection, int groupSize) {
        Class<Object> collectionClass = collection.getClass();
        ArrayList<CollectionWrapper> groups = null;
        try {
            groups = (ArrayList<CollectionWrapper>)BeanUtils.newInstance(collectionClass);
        }
        catch (ReflectionException e) {
            groups = new ArrayList<CollectionWrapper>();
            collectionClass = ArrayList.class;
        }
        int i = 0;
        CollectionWrapper wrapper = null;
        for (Object object : collection) {
            if (i == groupSize) {
                i = 0;
            }
            if (i == 0) {
                wrapper = new CollectionWrapper((Collection)BeanUtils.newInstance(collectionClass));
                groups.add(wrapper);
            }
            wrapper.getCollection().add(object);
            ++i;
        }
        return groups;
    }

    public static Collection<CollectionWrapper> groupBy(Collection collection, Class elementClass, String fieldToGroup) {
        Class<Object> collectionClass = collection.getClass();
        ArrayList<CollectionWrapper> groups = null;
        PropertyInfo property = BeanUtils.getPropertyInfo(elementClass, fieldToGroup);
        try {
            groups = (ArrayList<CollectionWrapper>)BeanUtils.newInstance(collectionClass);
        }
        catch (ReflectionException e) {
            groups = new ArrayList<CollectionWrapper>();
            collectionClass = ArrayList.class;
        }
        Object grouper = null;
        CollectionWrapper wrapper = null;
        for (Object object : collection) {
            Object grouperTarget = null;
            grouperTarget = property.is(Boolean.class) ? BeanUtils.invokeBooleanGetMethod(object, fieldToGroup) : BeanUtils.invokeGetMethod(object, fieldToGroup);
            if (grouper != null && !grouper.equals(grouperTarget)) {
                grouper = null;
            }
            if (grouper == null && grouperTarget != null) {
                grouper = grouperTarget;
                wrapper = new CollectionWrapper((Collection)BeanUtils.newInstance(collectionClass));
                wrapper.setName(grouperTarget.toString());
                groups.add(wrapper);
            }
            if (wrapper.getCollection() == null) continue;
            wrapper.getCollection().add(object);
        }
        return groups;
    }

    public static <T> T findFirst(Collection<T> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection instanceof List) {
            return (T)((List)collection).get(0);
        }
        return collection.stream().findFirst().get();
    }

    public static List iteratorToList(Iterator iterator) {
        ArrayList list = new ArrayList();
        iterator.forEachRemaining(t -> list.add(t));
        return list;
    }

    private CollectionsUtils() {
    }
}

