/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons.collect;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tools.dynamia.commons.collect.SetMultiMap;

public class HashSetMultiMap<K, V>
implements SetMultiMap<K, V> {
    private final Map<K, Set<V>> delegate = new HashMap<K, Set<V>>();

    @Override
    public Set<V> get(K key) {
        return this.delegate.get(key);
    }

    @Override
    public Set<V> remove(K key) {
        return this.delegate.remove(key);
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V put(K key, V value) {
        HashSet<V> set = this.get((Object)key);
        if (set == null) {
            set = new HashSet<V>();
            this.delegate.put(key, set);
        }
        set.add(value);
        return value;
    }

    @Override
    public void put(K key, V value, V ... values) {
        this.put(key, value);
        for (V newValue : values) {
            this.put(key, newValue);
        }
    }

    @Override
    public void putAll(K key, Collection<V> values) {
        for (V newValue : values) {
            this.put(key, newValue);
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public K getKey(V value) {
        K key = null;
        for (Map.Entry<K, Set<V>> entry : this.delegate.entrySet()) {
            if (!entry.getValue().contains(value)) continue;
            key = entry.getKey();
        }
        return key;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }
}

