/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons.collect;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public interface MultiMap<K, V> {
    public V put(K var1, V var2);

    public void put(K var1, V var2, V ... var3);

    public void putAll(K var1, Collection<V> var2);

    public Collection<V> get(K var1);

    public boolean containsKey(K var1);

    public Collection<V> remove(K var1);

    public void clear();

    public Set<K> keySet();

    public K getKey(V var1);

    public boolean isEmpty();

    default public void forEach(BiConsumer<? super K, ? super Collection<V>> action) {
        Objects.requireNonNull(action);
        for (K key : this.keySet()) {
            Collection<V> v;
            try {
                v = this.get(key);
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(key, v);
        }
    }
}

