/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons.collect;

import java.util.AbstractList;
import tools.dynamia.commons.collect.PagedListDataSource;

public class PagedList<T>
extends AbstractList<T> {
    private PagedListDataSource<T> dataSource;

    public PagedList(PagedListDataSource<T> dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public T get(int index) {
        return this.dataSource.getData(index);
    }

    @Override
    public int size() {
        return this.dataSource.getTotalSize();
    }

    @Override
    public void clear() {
        this.dataSource.clear();
    }

    @Override
    public String toString() {
        return this.dataSource.toString();
    }

    @Override
    public Object[] toArray() {
        return this.dataSource.getPageData().toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.dataSource.getPageData().toArray(a);
    }

    public PagedListDataSource<T> getDataSource() {
        return this.dataSource;
    }

    @Override
    public void add(int index, T element) {
        this.dataSource.getPageData().add(index, element);
    }
}

