/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons.logger;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.dynamia.commons.logger.LoggingService;

public class SLF4JLoggingService
implements LoggingService,
Serializable {
    private static final long serialVersionUID = -4196725472501595832L;
    private Logger logger = null;
    private String prefix = "";

    public SLF4JLoggingService() {
        this.logger = LoggerFactory.getLogger(LoggingService.class);
    }

    public SLF4JLoggingService(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public SLF4JLoggingService(Class<?> clazz, String prefix) {
        this(clazz);
        if (prefix == null) {
            prefix = "";
        }
        this.prefix = prefix;
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.prefix + message);
        }
    }

    @Override
    public void info(String message) {
        this.logger.info(this.prefix + message);
    }

    @Override
    public void warn(String message) {
        this.logger.warn(this.prefix + message);
    }

    @Override
    public void error(String message) {
        this.logger.error(this.prefix + message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logger.error(this.prefix + message, t);
    }

    @Override
    public void error(Throwable t) {
        this.logger.error(this.prefix + t.getMessage(), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }
}

