/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.commons.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.commons.reflect.AccessMode;

public class PropertyInfo
implements Serializable {
    private static final long serialVersionUID = -7216416220508812001L;
    private String name;
    private Class<?> type;
    private Class<?> ownerClass;
    private Class<?> genericType;
    private boolean collection;
    private AccessMode accessMode;
    private Method readMethod;
    private Method writeMethod;

    public PropertyInfo(String name, Class<?> type, Class<?> ownerClass, AccessMode accessMode) {
        this.name = name;
        this.type = type;
        this.ownerClass = ownerClass;
        this.accessMode = accessMode;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isEnum() {
        return this.getType().isEnum();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public boolean isStandardClass() {
        if (this.getType().isPrimitive()) {
            return true;
        }
        String name = this.getType().getName();
        return name.startsWith("java.lang") || name.startsWith("java.util") || name.startsWith("java.math");
    }

    public boolean is(Class<?> clazz) {
        return BeanUtils.isAssignable(this.getType(), clazz);
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public Class<?> getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Class<?> genericType) {
        this.genericType = genericType;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public String toString() {
        return StringUtils.capitalize(StringUtils.addSpaceBetweenWords(this.name));
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    public Field getField() {
        if (this.ownerClass != null) {
            try {
                return BeanUtils.getField(this.ownerClass, this.getName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        Boolean result = null;
        Field field = this.getField();
        if (field != null) {
            result = field.isAnnotationPresent(annotationClass);
        }
        if ((result == null || result == Boolean.FALSE) && this.readMethod != null) {
            result = this.readMethod.isAnnotationPresent(annotationClass);
        }
        if (result == null) {
            result = false;
        }
        return result;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        A result = null;
        Field field = this.getField();
        if (field != null) {
            result = field.getAnnotation(annotationClass);
        }
        if (result == null && this.readMethod != null) {
            result = this.readMethod.getAnnotation(annotationClass);
        }
        return result;
    }
}

