/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.crud;

import java.util.ArrayList;
import java.util.Date;
import tools.dynamia.commons.ApplicableClass;
import tools.dynamia.commons.Messages;
import tools.dynamia.domain.AbstractEntity;
import tools.dynamia.domain.query.Between;
import tools.dynamia.domain.query.EndsWith;
import tools.dynamia.domain.query.Equals;
import tools.dynamia.domain.query.GreaterEqualsThan;
import tools.dynamia.domain.query.GreaterThan;
import tools.dynamia.domain.query.Inlist;
import tools.dynamia.domain.query.LessEqualsThan;
import tools.dynamia.domain.query.LessThan;
import tools.dynamia.domain.query.LikeEquals;
import tools.dynamia.domain.query.QueryCondition;
import tools.dynamia.domain.query.StartsWith;

public enum FilterCondition {
    EQUALS(FilterCondition.msg("equals"), Equals.class, ApplicableClass.ALL),
    INLIST(FilterCondition.msg("inlist"), Inlist.class, ApplicableClass.get((Class[])new Class[]{AbstractEntity.class, Enum.class})),
    CONTAINS(FilterCondition.msg("contains"), LikeEquals.class, ApplicableClass.get((Class[])new Class[]{String.class})),
    STARTS(FilterCondition.msg("startswith"), StartsWith.class, ApplicableClass.get((Class[])new Class[]{String.class})),
    ENDS(FilterCondition.msg("endswith"), EndsWith.class, ApplicableClass.get((Class[])new Class[]{String.class})),
    BETWEEN(FilterCondition.msg("between"), Between.class, ApplicableClass.get((Class[])new Class[]{Date.class, Number.class})),
    LESS(FilterCondition.msg("less"), LessThan.class, ApplicableClass.get((Class[])new Class[]{Date.class, Number.class})),
    LESS_EQ(FilterCondition.msg("lesseq"), LessEqualsThan.class, ApplicableClass.get((Class[])new Class[]{Date.class, Number.class})),
    GREATER(FilterCondition.msg("greater"), GreaterThan.class, ApplicableClass.get((Class[])new Class[]{Date.class, Number.class})),
    GREATER_EQ(FilterCondition.msg("greatereq"), GreaterEqualsThan.class, ApplicableClass.get((Class[])new Class[]{Date.class, Number.class}));

    private final String label;
    private final Class<? extends QueryCondition> conditionClass;
    private final ApplicableClass[] applicableClasses;

    private FilterCondition(String label, Class<? extends QueryCondition> conditionClass, ApplicableClass[] applicableClasses) {
        this.label = label;
        this.conditionClass = conditionClass;
        this.applicableClasses = applicableClasses;
    }

    public String getLabel() {
        return this.label;
    }

    public Class<? extends QueryCondition> getConditionClass() {
        return this.conditionClass;
    }

    public String toString() {
        return this.getLabel();
    }

    public static FilterCondition[] getApplicableConditions(Class<?> type) {
        ArrayList<FilterCondition> app = new ArrayList<FilterCondition>();
        for (FilterCondition filterCondition : FilterCondition.values()) {
            if (!ApplicableClass.isApplicable(type, (ApplicableClass[])filterCondition.applicableClasses, (boolean)true)) continue;
            app.add(filterCondition);
        }
        return app.toArray(new FilterCondition[0]);
    }

    private static String msg(String key) {
        return Messages.get(FilterCondition.class, (String)key);
    }
}

