/*
 * Copyright (C) 2023 Dynamia Soluciones IT S.A.S - NIT 900302344-1
 * Colombia / South America
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package tools.dynamia.crud;

import tools.dynamia.actions.ActionEvent;

import java.util.Map;

@SuppressWarnings("rawtypes")
public class CrudActionEvent extends ActionEvent {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private final GenericCrudView crudView;
    private final CrudControllerAPI controller;

    public CrudActionEvent(Object data, Object source, GenericCrudView view, CrudControllerAPI controller) {
        this(data, source, null, view, controller);
    }

    public CrudActionEvent(Object data, Object source, Map<String, Object> params, GenericCrudView view, CrudControllerAPI controller) {
        super(data, source, params);
        this.crudView = view;
        this.controller = controller;
    }

    public GenericCrudView getCrudView() {
        return crudView;
    }


    public CrudControllerAPI getController() {
        return controller;
    }

}
