/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.crud;

import tools.dynamia.actions.AbstractClassAction;
import tools.dynamia.actions.ActionEvent;
import tools.dynamia.commons.ApplicableClass;
import tools.dynamia.crud.CrudAction;
import tools.dynamia.crud.CrudActionEvent;
import tools.dynamia.crud.CrudControllerAPI;
import tools.dynamia.crud.CrudState;
import tools.dynamia.crud.GenericCrudView;
import tools.dynamia.domain.services.CrudService;
import tools.dynamia.domain.util.DomainUtils;

public abstract class AbstractCrudAction
extends AbstractClassAction
implements CrudAction {
    private boolean menuSupported;
    private ApplicableClass[] applicableClasses = ApplicableClass.ALL;
    private CrudState[] applicableStates = CrudState.get(CrudState.READ);
    private CrudService crudService;

    public void actionPerformed(ActionEvent evt) {
        CrudActionEvent crudEvt;
        if (evt instanceof CrudActionEvent) {
            crudEvt = (CrudActionEvent)evt;
        } else {
            crudEvt = new CrudActionEvent(evt.getData(), evt.getSource(), (GenericCrudView)evt.getParam("crudview"), (CrudControllerAPI)evt.getParam("controllers"));
            crudEvt.getParams().putAll(evt.getParams());
        }
        this.actionPerformed(crudEvt);
    }

    public abstract void actionPerformed(CrudActionEvent var1);

    @Override
    public boolean isMenuSupported() {
        return this.menuSupported;
    }

    public void setMenuSupported(boolean menuSupported) {
        this.menuSupported = menuSupported;
    }

    @Override
    public CrudState[] getApplicableStates() {
        return this.applicableStates;
    }

    public void setApplicableStates(CrudState[] applicableStates) {
        this.applicableStates = applicableStates;
    }

    public ApplicableClass[] getApplicableClasses() {
        return this.applicableClasses;
    }

    public void setApplicableClasses(ApplicableClass[] applicableClasses) {
        this.applicableClasses = applicableClasses;
    }

    public void setApplicableClass(Class clazz) {
        this.setApplicableClasses(ApplicableClass.get((Class[])new Class[]{clazz}));
    }

    public Class getApplicableClass() {
        if (this.applicableClasses.length > 0) {
            return this.applicableClasses[0].targetClass();
        }
        return null;
    }

    protected CrudService crudService() {
        if (this.crudService == null) {
            this.crudService = DomainUtils.lookupCrudService();
        }
        return this.crudService;
    }
}

