/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.crud;

import tools.dynamia.commons.StringUtils;
import tools.dynamia.crud.CrudPageException;
import tools.dynamia.domain.AbstractEntity;
import tools.dynamia.navigation.RendereablePage;

public abstract class AbstractCrudPage<T>
extends RendereablePage<T> {
    private static final long serialVersionUID = -4645019919823261595L;
    private Class entityClass;

    public AbstractCrudPage(Class<? extends AbstractEntity> entityClass) {
        this("crud" + entityClass.getSimpleName(), StringUtils.addSpaceBetweenWords((CharSequence)entityClass.getSimpleName()), entityClass);
    }

    public AbstractCrudPage(String id, String name, Class<? extends AbstractEntity> entityClass) {
        super(id, name, entityClass.getName());
        this.entityClass = entityClass;
    }

    protected void loadObjectClass() {
        try {
            if (this.entityClass == null) {
                this.entityClass = Class.forName(this.getPath());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CrudPageException("Invalid class path", classNotFoundException);
        }
    }

    public Class getEntityClass() {
        return this.entityClass;
    }
}

