/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.crud.actions;

import tools.dynamia.actions.ActionGroup;
import tools.dynamia.actions.InstallAction;
import tools.dynamia.commons.Callback;
import tools.dynamia.commons.Messages;
import tools.dynamia.crud.AbstractCrudAction;
import tools.dynamia.crud.CrudActionEvent;
import tools.dynamia.crud.CrudState;
import tools.dynamia.crud.GenericCrudView;
import tools.dynamia.domain.ValidationError;

@InstallAction
public class SaveAction
extends AbstractCrudAction {
    public SaveAction() {
        this.setName(Messages.get(this.getClass(), (String)"save"));
        this.setImage("save");
        this.setGroup(ActionGroup.get((String)"CRUD"));
        this.setPosition(1.0);
        this.setShowLabel(true);
        this.setType("primary");
    }

    @Override
    public CrudState[] getApplicableStates() {
        return CrudState.get(CrudState.CREATE, CrudState.UPDATE);
    }

    @Override
    public void actionPerformed(CrudActionEvent evt) {
        GenericCrudView crud = evt.getCrudView();
        crud.getController().setEntity(evt.getData());
        try {
            crud.getController().doSave();
        }
        catch (ValidationError e) {
            crud.handleValidationError(e);
        }
        Callback afterSave = () -> {
            if (crud.getController().isSaved()) {
                crud.setState(CrudState.READ);
                this.afterSave(evt.getData(), crud);
            }
        };
        if (crud.getController().isConfirmBeforeSave()) {
            crud.getController().onSave(afterSave);
        } else {
            afterSave.doSomething();
        }
    }

    protected void afterSave(Object entity, GenericCrudView crud) {
    }
}

