/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.io;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.io.IOUtils;
import tools.dynamia.io.ImageScaler;
import tools.dynamia.io.ImageType;
import tools.dynamia.io.qr.QRCode;
import tools.dynamia.io.qr.QRGenerationException;

public class ImageUtil {
    public static final String DOT_JPG = ".jpg";
    public static final String JPG = "jpg";
    public static final String DOT_JPEG = ".jpeg";
    public static final String DOT_WEBP = ".webp";
    public static final String PNG = "png";
    public static final String GIF = "gif";
    public static final String WEBP = "webp";

    public static void resizeJPEGImage(File input, File output, int thumbWidth, int thumbHeight) {
        ImageUtil.resizeImage(input, output, "jpeg", thumbWidth, thumbHeight);
    }

    public static void resizeImage(File input, File output, String formatName, int thumbWidth, int thumbHeight) {
        try {
            BufferedImage image = ImageIO.read(input);
            BufferedImage newImage = ImageScaler.resize(image, thumbWidth, thumbHeight, new BufferedImageOp[0]);
            output.getParentFile().mkdirs();
            output.createNewFile();
            ImageIO.write((RenderedImage)newImage, formatName, output);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static boolean isImage(File file) {
        if (!file.exists()) {
            String name = file.getName().toLowerCase();
            return name.endsWith(JPG) || name.endsWith(PNG) || name.endsWith(GIF) || name.endsWith(WEBP);
        }
        String mimetype = ImageUtil.getMimetype(file);
        if (mimetype != null) {
            return mimetype.contains("image");
        }
        return false;
    }

    public static String getMimetype(File file) {
        return URLConnection.guessContentTypeFromName(file.getName());
    }

    public static int getBrightness(String colorStr) {
        Color c = ImageUtil.getColor(colorStr);
        if (c != null) {
            return (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
        }
        return -1;
    }

    public static Color getColor(String colorStr) {
        if (colorStr == null) {
            return null;
        }
        if (colorStr.startsWith("#")) {
            return Color.decode(colorStr);
        }
        try {
            return (Color)BeanUtils.getField(Color.class, (String)colorStr).get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isDark(String color) {
        return ImageUtil.getBrightness(color) < 130;
    }

    public static boolean isLight(String color) {
        return ImageUtil.getBrightness(color) >= 130;
    }

    public static File convertPngToJpg(File input) {
        try {
            if (input.getName().endsWith(DOT_JPG) || input.getName().endsWith(DOT_JPEG)) {
                return input;
            }
            File output = new File(input.getParentFile(), StringUtils.removeFilenameExtension((String)input.getName()) + DOT_JPG);
            BufferedImage image = ImageIO.read(input);
            BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            result.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
            ImageIO.write((RenderedImage)result, JPG, output);
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getWidth(File image) {
        try {
            return ImageIO.read(image).getWidth();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int getHeight(File image) {
        try {
            return ImageIO.read(image).getHeight();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static File generateQR(String content) {
        return QRCode.from(content).to(ImageType.JPG).file();
    }

    public static File generateQR(String content, int width, int height) {
        return QRCode.from(content).withSize(width, height).to(ImageType.JPG).file();
    }

    public static String generateQRBase64(String content) {
        try {
            return IOUtils.encodeBase64(ImageUtil.generateQR(content));
        }
        catch (IOException e) {
            throw new QRGenerationException("Exception generating base 64 qr code", e);
        }
    }

    public static String generateQRBase64(String content, int width, int height) {
        try {
            return IOUtils.encodeBase64(ImageUtil.generateQR(content, width, height));
        }
        catch (IOException e) {
            throw new QRGenerationException("Exception generating base 64 qr code", e);
        }
    }

    private ImageUtil() {
    }
}

