/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.integration.Containers;
import tools.dynamia.io.FileInfo;
import tools.dynamia.io.Resource;
import tools.dynamia.io.ResourceLocator;
import tools.dynamia.io.impl.SpringResourceLocator;

public abstract class IOUtils {
    private static final ResourceLocator DEFAULT_RESOURCE_LOCATOR;
    private static final LoggingService LOGGER;

    private IOUtils() {
    }

    public static Resource getResource(String location) {
        Resource resource = null;
        Collection locators = Containers.get().findObjects(ResourceLocator.class);
        if (locators != null && !locators.isEmpty()) {
            ResourceLocator resourceLocator;
            Iterator iterator = locators.iterator();
            while (iterator.hasNext() && (resource = (resourceLocator = (ResourceLocator)iterator.next()).getResource(location)) == null) {
            }
        } else {
            resource = DEFAULT_RESOURCE_LOCATOR.getResource(location);
        }
        return resource;
    }

    public static Resource[] getResources(String location) throws IOException {
        Resource[] results = new Resource[]{};
        Collection locators = Containers.get().findObjects(ResourceLocator.class);
        if (locators != null && !locators.isEmpty()) {
            for (ResourceLocator resourceLocator : locators) {
                Resource[] resources = resourceLocator.getResources(location);
                if (resources == null) continue;
                results = resources;
                break;
            }
        } else {
            results = DEFAULT_RESOURCE_LOCATOR.getResources(location);
        }
        return results;
    }

    public static File createFromClasspath(String path) {
        try {
            return new File(IOUtils.class.getResource(path).toURI());
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static byte[] serializeToBytes(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        return baos.toByteArray();
    }

    public static Serializable deserializeFromBytes(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (Serializable)ois.readObject();
    }

    public static String readContent(String path) throws IOException {
        InputStream in = IOUtils.class.getResourceAsStream(path);
        if (in == null) {
            in = new FileInputStream(path);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder content = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            content.append(line);
        }
        return content.toString();
    }

    public static String readContent(String path, String charset) throws IOException {
        InputStream in = IOUtils.class.getResourceAsStream(path);
        if (in == null) {
            in = new FileInputStream(path);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in, charset));
        StringBuilder content = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            content.append(line);
        }
        return content.toString();
    }

    public static void copy(InputStream streamIn, OutputStream streamOut) throws IOException {
        ReadableByteChannel src = Channels.newChannel(streamIn);
        WritableByteChannel dest = Channels.newChannel(streamOut);
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static void copy(InputStream streamIn, File fileOut) throws IOException {
        IOUtils.copy(streamIn, (OutputStream)new FileOutputStream(fileOut));
    }

    public static void copy(File fileIn, File fileOut) throws IOException {
        FileInputStream fis = new FileInputStream(fileIn);
        FileOutputStream fos = new FileOutputStream(fileOut);
        IOUtils.copy((InputStream)fis, (OutputStream)fos);
    }

    public static void copy(byte[] bytes, File fileOut) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        FileOutputStream fos = new FileOutputStream(fileOut);
        IOUtils.copy((InputStream)bais, (OutputStream)fos);
    }

    public static void copy(byte[] bytes, OutputStream streamOut) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        IOUtils.copy((InputStream)bais, streamOut);
    }

    public static String formatFileSize(long length) {
        DecimalFormat f = new DecimalFormat("###,###.#");
        if (length > 1024L) {
            double kb = (double)length / 1024.0;
            if (kb > 1024.0) {
                double mb = kb / 1024.0;
                if (mb > 1024.0) {
                    double gb = mb / 1024.0;
                    return f.format(gb) + " GB";
                }
                return f.format(mb) + " MB";
            }
            return f.format(kb) + " KB";
        }
        return length + " B";
    }

    public static String getFileNameWithoutExtension(File file) {
        String name = file.getName();
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static FileInfo find(String name, List<FileInfo> fileList) {
        for (FileInfo fileInfo : fileList) {
            if (!fileInfo.getName().equals(name)) continue;
            return fileInfo;
        }
        return null;
    }

    public static void unzipFile(File zipFile, File outputfolder) throws IOException {
        byte[] buffer = new byte[1024];
        if (!outputfolder.exists()) {
            outputfolder.mkdir();
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(outputfolder, fileName);
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    new File(newFile.getParent()).mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTempDirectory() {
        return new File(IOUtils.getTempDirectoryPath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.home");
    }

    public static File getUserDirectory() {
        return new File(IOUtils.getUserDirectoryPath());
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (File file : files) {
                if (file.isDirectory()) {
                    IOUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    public static Path downloadFile(String baseURL, String fileURI, String localFolder) throws Exception {
        if (baseURL == null || baseURL.isEmpty()) {
            LOGGER.info("-No base URL  to download file: " + fileURI);
            return null;
        }
        if (fileURI != null && !fileURI.isEmpty()) {
            Path path;
            block13: {
                String separator = "/";
                if (baseURL.endsWith("/")) {
                    separator = "";
                }
                URL url = new URL(baseURL + separator + fileURI);
                Path folder = Paths.get(localFolder, new String[0]);
                Path localFile = folder.resolve(fileURI);
                if (Files.notExists(folder, new LinkOption[0])) {
                    Files.createDirectories(folder, new FileAttribute[0]);
                }
                InputStream in = url.openStream();
                try {
                    Files.copy(in, localFile, StandardCopyOption.REPLACE_EXISTING);
                    path = localFile;
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOGGER.error("-Error downloading file " + fileURI, (Throwable)ex);
                    }
                }
                in.close();
            }
            return path;
        } else {
            LOGGER.info("-No file to download");
        }
        return null;
    }

    public static String encodeBase64(File file) throws IOException {
        return Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
    }

    public static void decodeBase64(String base64, File outputFile) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            byte[] data = Base64.getDecoder().decode(base64.getBytes());
            outputStream.write(data);
        }
    }

    static {
        LOGGER = new SLF4JLoggingService(IOUtils.class);
        SpringResourceLocator locator = new SpringResourceLocator();
        locator.setApplicationContext((ApplicationContext)new AnnotationConfigApplicationContext());
        DEFAULT_RESOURCE_LOCATOR = locator;
    }
}

