/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.io.converters;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import tools.dynamia.integration.Containers;
import tools.dynamia.io.converters.Converter;
import tools.dynamia.io.converters.ConverterException;

public class Converters {
    private static final Map<Class, Converter> CACHE = Collections.synchronizedMap(new HashMap());

    private Converters() {
    }

    public static <T> Converter<T> getConverter(Class<T> clazz) {
        Collection converters;
        if (CACHE.isEmpty() && (converters = Containers.get().findObjects(Converter.class)) != null) {
            for (Converter converter : converters) {
                CACHE.put(converter.getTargetClass(), converter);
            }
        }
        return CACHE.get(clazz);
    }

    public static String convert(Object value) {
        if (value == null) {
            return null;
        }
        Converter<Object> converter = null;
        converter = value instanceof Class ? Converters.getConverter((Class)value) : Converters.getConverter(value.getClass());
        if (converter != null) {
            return converter.toString(value);
        }
        throw new ConverterException("No converter found for type " + value.getClass());
    }

    public static <T> T convert(Class<T> clazz, String value) {
        if (value == null) {
            return null;
        }
        Converter<T> converter = Converters.getConverter(clazz);
        if (converter != null) {
            return converter.toObject(value);
        }
        throw new ConverterException("No converter found for type " + clazz);
    }
}

