/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.io;

import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.io.FileException;
import tools.dynamia.io.IOUtils;
import tools.dynamia.io.ImageUtil;
import tools.dynamia.io.VirtualFile;

public class FileInfo {
    private String name;
    private String description;
    private final File file;
    private final String fileSize;
    private final Date fileDate;
    private final String extension;
    private boolean directory;
    private boolean readOnly;
    private String icon;
    private final Map<String, Object> metaData = new ConcurrentHashMap<String, Object>();

    public FileInfo(File file) {
        this.file = file;
        this.name = file.getName();
        this.extension = IOUtils.getFileExtension(file);
        this.description = StringUtils.addSpaceBetweenWords((CharSequence)StringUtils.capitalize((String)IOUtils.getFileNameWithoutExtension(file)));
        this.fileSize = IOUtils.formatFileSize(file.length());
        this.fileDate = new Date(file.lastModified());
        this.directory = file.isDirectory();
        this.readOnly = !file.canWrite();
        this.icon = this.extension;
        if (this.isDirectory()) {
            this.icon = "folder";
        }
    }

    public FileInfo(File file, String description) {
        this(file);
        this.description = description;
    }

    public FileInfo(File file, String name, String description) {
        this(file);
        this.name = name;
        this.description = description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public Date getFileDate() {
        return this.fileDate;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean delete() {
        if (this.readOnly) {
            throw new FileException("File " + this.getName() + " is read only, cannot be deleted");
        }
        if (this.file != null) {
            return this.file.delete();
        }
        return false;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isImage() {
        return ImageUtil.isImage(this.file);
    }

    public void addMetadata(String name, Object value) {
        this.metaData.put(name, value);
    }

    public Object getMetadata(String name) {
        return this.metaData.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return Objects.equals(this.file, fileInfo.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public String toString() {
        return this.file.getPath();
    }

    public boolean isVirtual() {
        return this.file instanceof VirtualFile;
    }
}

