/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class VirtualFile
extends File {
    private static final long serialVersionUID = 4878149422782768585L;
    private boolean canWrite;
    private long length;
    private boolean directory;
    private List<File> children = new ArrayList<File>();
    private String name;

    public VirtualFile(File parent, String child) {
        super(parent, child);
        this.name = super.getName();
    }

    public VirtualFile(String parent, String child) {
        super(parent, child);
        this.name = super.getName();
    }

    public VirtualFile(String pathname) {
        super(pathname);
        this.name = super.getName();
    }

    public VirtualFile(URI uri) {
        super(uri);
        this.name = super.getName();
    }

    public VirtualFile(String pathname, boolean canWrite, long length, boolean directory, List<File> children) {
        super(pathname);
        this.canWrite = canWrite;
        this.length = length;
        this.directory = directory;
        this.children = children;
        this.name = super.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void add(File file) {
        this.children.add(file);
        this.directory = true;
        this.canWrite = true;
    }

    @Override
    public String[] list() {
        return (String[])this.getChildren().stream().map(File::getPath).toArray(String[]::new);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return (String[])this.getChildren().stream().filter(f -> filter.accept(f.getParentFile(), f.getName())).map(File::getPath).toArray(String[]::new);
    }

    @Override
    public File[] listFiles() {
        return this.getChildren().toArray(new File[0]);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        assert (filter != null);
        return (File[])this.getChildren().stream().filter(filter::accept).toArray(File[]::new);
    }

    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    @Override
    public long length() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public List<File> getChildren() {
        return this.children;
    }

    @Override
    public boolean delete() {
        if (this.canWrite) {
            return super.delete();
        }
        return false;
    }
}

