/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.io.impl;

import java.io.IOException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import tools.dynamia.io.Resource;
import tools.dynamia.io.ResourceLocator;
import tools.dynamia.io.impl.SpringResource;

@Component
public class SpringResourceLocator
implements ResourceLocator,
ApplicationContextAware {
    private ApplicationContext appContext;

    @Override
    public Resource getResource(String location) {
        org.springframework.core.io.Resource res = this.appContext.getResource(location);
        if (res != null) {
            return new SpringResource(res);
        }
        return null;
    }

    @Override
    public Resource[] getResources(String location) throws IOException {
        org.springframework.core.io.Resource[] res = this.appContext.getResources(location);
        if (res != null && res.length > 0) {
            Resource[] resources = new Resource[res.length];
            for (int i = 0; i < resources.length; ++i) {
                resources[i] = new SpringResource(res[i]);
            }
            return resources;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.appContext = applicationContext;
    }
}

