/*
 * Decompiled with CFR 0.152.
 */
package converters;

import converters.Util;
import java.text.NumberFormat;
import java.util.Locale;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import tools.dynamia.commons.Messages;

public class Currency
implements Converter<Object, Object, Component> {
    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        if (val instanceof Number) {
            NumberFormat formatter = this.buildFormatter();
            Util.applyStylesClass((Number)val, comp);
            return formatter.format(val);
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        NumberFormat formatter = this.buildFormatter();
        return Util.coerceToBean(val, formatter);
    }

    private NumberFormat buildFormatter() {
        Locale locale = Messages.getDefaultLocale();
        return NumberFormat.getCurrencyInstance(locale);
    }

    public String format(Number number) {
        return (String)this.coerceToUi(number, null, null);
    }
}

