/*
 * Decompiled with CFR 0.152.
 */
package converters;

import converters.Util;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import tools.dynamia.commons.Messages;

public class Decimal
implements Converter<Object, Object, Component> {
    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        if (val instanceof Number) {
            NumberFormat formatter = this.buildFormatter();
            Util.applyStylesClass((Number)val, comp);
            return formatter.format(val);
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        return Util.coerceToBean(val, this.buildFormatter());
    }

    public String format(Number number) {
        return (String)this.coerceToUi(number, null, null);
    }

    private NumberFormat buildFormatter() {
        Locale locale = Messages.getDefaultLocale();
        NumberFormat formatter = DecimalFormat.getInstance(locale);
        return formatter;
    }
}

