/*
 * Decompiled with CFR 0.152.
 */
package converters;

import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.Listcell;
import tools.dynamia.commons.DateTimeUtils;

public class Util {
    public static void applyStylesClass(Number num, Component comp) {
        if (comp == null || num == null) {
            return;
        }
        if (comp.getParent() != null && comp.getParent() instanceof Listcell) {
            return;
        }
        Object ignoreStyles = comp.getAttribute("ignoreStyles");
        if (ignoreStyles == Boolean.TRUE) {
            return;
        }
        if (comp instanceof HtmlBasedComponent) {
            HtmlBasedComponent hcomp = (HtmlBasedComponent)comp;
            if (num.longValue() > 0L) {
                hcomp.setSclass("conv-positive");
            } else if (num.longValue() < 0L) {
                hcomp.setSclass("conv-negative");
            } else {
                hcomp.setSclass("conv-zero");
            }
        }
    }

    public static void applyStylesClass(Date date, Component comp) {
        if (comp != null && comp.getAttribute("ignoreStyles") == Boolean.TRUE) {
            return;
        }
        if (comp instanceof HtmlBasedComponent) {
            HtmlBasedComponent hcomp = (HtmlBasedComponent)comp;
            if (DateTimeUtils.isFuture((Date)date)) {
                hcomp.setSclass("conv-future");
            } else if (DateTimeUtils.isPast((Date)date)) {
                hcomp.setSclass("conv-past");
            } else {
                hcomp.setSclass("conv-present");
            }
        }
    }

    public static Object coerceToBean(Object val, Format format) {
        if (val != null) {
            try {
                return format.parseObject(val.toString());
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private Util() {
    }
}

