/*
 * Decompiled with CFR 0.152.
 */
package navigation.builders;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zhtml.Div;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.A;
import org.zkoss.zul.Label;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.Vbox;
import tools.dynamia.navigation.Module;
import tools.dynamia.navigation.NavigationManager;
import tools.dynamia.navigation.NavigationViewBuilder;
import tools.dynamia.navigation.Page;
import tools.dynamia.navigation.PageGroup;

public class Accordion
implements NavigationViewBuilder<Tabbox> {
    private final transient Tabbox tabbox;
    private final transient Map<Module, Vbox> modulesContent = new HashMap<Module, Vbox>();

    public Accordion() {
        this.tabbox = new Tabbox();
        this.tabbox.setWidth("100%");
        this.tabbox.setMold("accordion-lite");
        Tabs tabs = new Tabs();
        tabs.setParent((Component)this.tabbox);
        Tabpanels panels = new Tabpanels();
        panels.setParent((Component)this.tabbox);
    }

    public Tabbox getNavigationView() {
        return this.tabbox;
    }

    public void createModuleView(Module module) {
        Tab tab = new Tab();
        tab.setLabel(module.getName());
        tab.setImage(module.getIcon());
        tab.setParent((Component)this.tabbox.getTabs());
        Tabpanel tp = new Tabpanel();
        tp.setParent((Component)this.tabbox.getTabpanels());
        Vbox box = new Vbox();
        box.setWidth("100%");
        box.setParent((Component)tp);
        this.modulesContent.put(module, box);
    }

    public void createPageGroupView(PageGroup pageGroup) {
        if (pageGroup.getParentModule().getPageGroups().size() > 1) {
            Vbox vbox = this.modulesContent.get(pageGroup.getParentModule());
            vbox.setSclass("nav-pagegroup");
            Div div = new Div();
            div.setParent((Component)vbox);
            div.setSclass("nav-pagegroup-title");
            new Label(pageGroup.getName()).setParent((Component)div);
        }
    }

    public void createPageView(Page page) {
        Vbox vbox = this.modulesContent.get(page.getPageGroup().getParentModule());
        A link = new A(page.getName());
        link.getAttributes().put("page", page);
        link.setParent((Component)vbox);
        link.addEventListener("onClick", evt -> NavigationManager.getCurrent().setCurrentPage(page));
    }
}

