/*
 * Decompiled with CFR 0.152.
 */
package navigation.builders;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Menubar;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import tools.dynamia.navigation.Module;
import tools.dynamia.navigation.NavigationManager;
import tools.dynamia.navigation.NavigationViewBuilder;
import tools.dynamia.navigation.Page;
import tools.dynamia.navigation.PageGroup;

public class Menu
implements NavigationViewBuilder<Menubar> {
    private final transient Menubar menubar;
    private final transient Map<Module, org.zkoss.zul.Menu> modulesContent = new HashMap<Module, org.zkoss.zul.Menu>();
    private final transient Map<PageGroup, org.zkoss.zul.Menu> pgContent = new HashMap<PageGroup, org.zkoss.zul.Menu>();

    public Menu() {
        this.menubar = new Menubar();
        this.menubar.setWidth("100%");
        this.menubar.setAutodrop(true);
        this.menubar.setSclass("menuNavBuilder");
    }

    public Menubar getNavigationView() {
        return this.menubar;
    }

    public void createModuleView(Module module) {
        if (module.getProperty("submenus") != Boolean.FALSE) {
            org.zkoss.zul.Menu menu = new org.zkoss.zul.Menu(module.getName());
            menu.setLabel(module.getName());
            menu.setImage(module.getIcon());
            menu.setParent((Component)this.menubar);
            new Menupopup().setParent((Component)menu);
            this.modulesContent.put(module, menu);
        }
    }

    public void createPageGroupView(PageGroup pageGroup) {
        boolean submenus = true;
        if (pageGroup.getParentModule() != null && pageGroup.getParentModule().getProperty("submenus") == Boolean.FALSE) {
            submenus = false;
        }
        if (submenus) {
            org.zkoss.zul.Menu menuPg = new org.zkoss.zul.Menu(pageGroup.getName());
            new Menupopup().setParent((Component)menuPg);
            org.zkoss.zul.Menu menu = null;
            menu = pageGroup.getParentModule() != null ? this.modulesContent.get(pageGroup.getParentModule()) : this.pgContent.get(pageGroup.getParentGroup());
            menuPg.setParent((Component)menu.getMenupopup());
            this.pgContent.put(pageGroup, menuPg);
        }
    }

    public void createPageView(Page page) {
        org.zkoss.zul.Menu menu = null;
        menu = page.getPageGroup().getParentModule() != null ? this.modulesContent.get(page.getPageGroup().getParentModule()) : this.pgContent.get(page.getPageGroup().getParentGroup());
        org.zkoss.zul.Menu menuPg = this.pgContent.get(page.getPageGroup());
        Menuitem menuitem = new Menuitem(page.getName());
        menuitem.getAttributes().put("page", page);
        menuitem.addEventListener("onClick", evt -> NavigationManager.getCurrent().setCurrentPage(page));
        if (menuPg != null) {
            menuitem.setParent((Component)menuPg.getMenupopup());
        } else if (menu != null) {
            menuitem.setParent((Component)menu.getMenupopup());
        } else {
            menuitem.setParent((Component)this.menubar);
        }
    }
}

