/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk;

import java.util.Map;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Window;
import tools.dynamia.domain.services.AbstractService;
import tools.dynamia.ui.UIMessages;
import tools.dynamia.zk.util.ZKBindingUtil;
import tools.dynamia.zk.util.ZKUtil;

public abstract class AbstractViewModel<T>
extends AbstractService {
    protected T model;
    protected Window parentWindow;
    protected Component view;
    private EventListener<Event> closeListener;

    @AfterCompose
    public void afterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        this.view = view;
        this.afterViewCompose();
    }

    @Init
    public void initDefaults() {
        this.model = ZKUtil.getExecutionEntity();
        this.parentWindow = ZKUtil.getExecutionParentWindow();
        this.afterInitDefaults();
    }

    protected void afterInitDefaults() {
    }

    protected void afterViewCompose() {
    }

    protected void enableOnCloseWindowConfirmation(final String message) {
        if (this.parentWindow != null) {
            this.closeListener = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    event.stopPropagation();
                    UIMessages.showQuestion((String)message, () -> {
                        AbstractViewModel.this.parentWindow.removeEventListener("onClose", (EventListener)this);
                        AbstractViewModel.this.parentWindow.detach();
                        Events.postEvent((Event)event);
                    });
                }
            };
            this.parentWindow.addEventListener("onClose", this.closeListener);
        }
    }

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    protected void notifyChanges() {
        ZKBindingUtil.postNotifyChange((Object)this);
    }

    protected void notifyChanges(String property) {
        ZKBindingUtil.postNotifyChange((Object)this, property);
    }

    protected void notifyChanges(String ... properties) {
        ZKBindingUtil.postNotifyChange((Object)this, properties);
    }

    protected void showDialog(String uri, String title, Object data) {
        ZKUtil.showDialog(uri, title, data);
    }

    protected void postGlobalCommand(String command) {
        ZKBindingUtil.postGlobalCommand(command);
    }

    protected void postGlobalCommand(String command, Map<String, Object> params) {
        ZKBindingUtil.postGlobalCommand(command, params);
    }

    protected void closeWindow() {
        if (this.parentWindow != null) {
            this.parentWindow.detach();
            if (this.closeListener != null) {
                this.parentWindow.removeEventListener("onClose", this.closeListener);
            }
            Events.postEvent((Event)new Event("onClose", (Component)this.parentWindow));
        }
    }

    public Object getArg(String name) {
        return ZKUtil.getExecutionArg(name);
    }

    public String getRequestParam(String name) {
        return Executions.getCurrent().getParameter(name);
    }
}

