/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Window;
import tools.dynamia.navigation.Page;
import tools.dynamia.navigation.RendereablePage;
import tools.dynamia.navigation.WorkspaceViewBuilder;
import tools.dynamia.zk.ui.DivContainer;
import tools.dynamia.zk.util.ZKUtil;

public abstract class AbstractZKWorkspaceBuilder
implements WorkspaceViewBuilder<Component> {
    protected Component container;
    protected Window currentWindow;

    public void init(Component container) {
        this.container = container;
    }

    public void update(Page page, Map<String, Object> params) {
        if (page != null) {
            Component pageContainer = this.getPageContainer(page);
            if (pageContainer == null) {
                pageContainer = this.container;
            }
            this.currentWindow = null;
            if (page.isShowAsPopup()) {
                Boolean showTitle;
                this.currentWindow = new Window(page.getName(), "normal", page.isClosable());
                this.currentWindow.setPage(ZKUtil.getFirstPage());
                this.currentWindow.setSclass("pageContentWindow");
                this.currentWindow.setContentStyle("flex-direction: unset");
                pageContainer = this.currentWindow;
                this.currentWindow.addEventListener("onClose", evt -> this.close(page));
                this.currentWindow.setWidth((String)page.getAttribute("width"));
                this.currentWindow.setHeight((String)page.getAttribute("height"));
                String title = (String)page.getAttribute("title");
                if (title != null && !title.isEmpty()) {
                    this.currentWindow.setTitle(title);
                }
                if ((showTitle = (Boolean)page.getAttribute("showTitle")) == Boolean.FALSE) {
                    if (this.currentWindow.getCaption() != null) {
                        this.currentWindow.getCaption().detach();
                    }
                    this.currentWindow.setBorder(false);
                    this.currentWindow.setClosable(false);
                    this.currentWindow.setTitle(null);
                }
                this.currentWindow.doModal();
            } else {
                this.clearPageContainer(pageContainer);
            }
            Component pageComponent = this.renderPage(pageContainer, page, params);
            if (pageComponent != null) {
                this.postUpdate(pageComponent, page, params);
            }
        }
    }

    public abstract Component getPageContainer(Page var1);

    public abstract void clearPageContainer(Component var1);

    protected void postUpdate(Component pageComponent, Page page, Map<String, Object> params) {
    }

    protected Component renderPage(Component pageContainer, Page page, Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("parentWindow", this.currentWindow);
        params.put("navigationPage", page);
        params.put("page", page);
        if (page instanceof RendereablePage) {
            RendereablePage renderPage = (RendereablePage)page;
            Component comp = (Component)renderPage.renderPage();
            if (comp != null) {
                comp.setParent(pageContainer);
            }
            return comp;
        }
        DivContainer pageContent = new DivContainer();
        pageContent.setSclass("pageContent");
        pageContent.setParent(pageContainer);
        if (page.isShowAsPopup()) {
            pageContent.setVflex("1");
        }
        ZKUtil.createComponent(page.getPath(), (Component)pageContent, params);
        return pageContent;
    }

    public void close(Page page) {
        if (this.currentWindow != null) {
            this.currentWindow.detach();
        } else if (this.container != null) {
            this.container.getChildren().clear();
        }
    }
}

