/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.springframework.jmx.access.InvocationFailureException;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.GlobalCommandEvent;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.zk.Subscribe;
import tools.dynamia.zk.ZKException;

public class EventQueueSubscriber {
    private final Object target;

    public EventQueueSubscriber(Object target) {
        this.target = target;
    }

    public void loadAnnotations() {
        Method[] methods;
        for (Method method : methods = BeanUtils.getMethodsWithAnnotation(this.target.getClass(), Subscribe.class)) {
            this.loadAnnotation(method);
        }
    }

    private void loadAnnotation(Method method) {
        Subscribe subscribe = method.getAnnotation(Subscribe.class);
        EventQueue queue = EventQueues.lookup((String)subscribe.value(), (String)subscribe.scope(), (boolean)subscribe.autocreate());
        queue.subscribe(evt -> {
            boolean completed = false;
            if (evt instanceof GlobalCommandEvent) {
                GlobalCommandEvent globalEvt = (GlobalCommandEvent)evt;
                if (subscribe.command().length > 0) {
                    for (String command : subscribe.command()) {
                        if (!globalEvt.getCommand().equals(command)) continue;
                        completed = this.invoke(method, evt);
                        break;
                    }
                } else if (globalEvt.getCommand().equals(method.getName())) {
                    completed = this.invoke(method, evt);
                }
            } else if (subscribe.eventName().isEmpty() || subscribe.eventName().equals(evt.getName())) {
                completed = this.invoke(method, evt);
            }
            if (completed) {
                this.notifyChange(subscribe, method);
            }
        }, subscribe.async());
    }

    private void notifyChange(Subscribe subscribe, Method method) {
        NotifyChange notifyChange = method.getAnnotation(NotifyChange.class);
        if (notifyChange != null) {
            for (String property : notifyChange.value()) {
                BindUtils.postNotifyChange(null, null, (Object)this.target, (String)property);
            }
        }
    }

    private boolean invoke(Method method, Event evt) {
        try {
            if (method.getParameterCount() == 0) {
                method.invoke(this.target, new Object[0]);
                return true;
            }
            if (evt.getData() != null && evt.getData().getClass().isArray()) {
                Object[] evtData = (Object[])evt.getData();
                Parameter[] parameters = method.getParameters();
                Object[] args = new Object[parameters.length];
                int start = 0;
                if (parameters[0].getType() == Event.class) {
                    args[0] = evt;
                    start = 1;
                }
                if (evtData.length + start != args.length) {
                    throw new ZKException("Invalid @Subscribe method, arguments not match");
                }
                System.arraycopy(evtData, 0, args, start, evtData.length);
                method.invoke(this.target, args);
                return true;
            }
            if (method.getParameterCount() == 1) {
                Class<?> paramType = method.getParameterTypes()[0];
                if (paramType == Event.class) {
                    method.invoke(this.target, evt);
                    return true;
                }
                if (paramType == Object.class) {
                    method.invoke(this.target, evt.getData());
                    return true;
                }
            }
            throw new InvocationFailureException("Subscribe method dont have correct parameters");
        }
        catch (Exception e) {
            throw new ZKException("Error invokin annotated @Subcribe method", e);
        }
    }
}

