/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import navigation.builders.Menu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import tools.dynamia.navigation.Module;
import tools.dynamia.navigation.ModuleComparator;
import tools.dynamia.navigation.ModuleContainer;
import tools.dynamia.navigation.NavigationElement;
import tools.dynamia.navigation.NavigationManager;
import tools.dynamia.navigation.NavigationRestrictions;
import tools.dynamia.navigation.NavigationViewBuilder;
import tools.dynamia.navigation.Page;
import tools.dynamia.navigation.PageGroup;

@org.springframework.stereotype.Component(value="navBuilder")
@Scope(value="prototype")
public class NavigationBuilder
extends GenericForwardComposer {
    @Autowired
    private NavigationManager navManager;
    @Autowired
    private ModuleContainer moduleContainer;
    private String navigationView;

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.navigationView = (String)this.self.getAttribute("builderClass");
        this.buildNavigation();
    }

    private void buildNavigation() {
        NavigationViewBuilder viewBuilder = this.createViewBuilder();
        ArrayList modules = new ArrayList(this.moduleContainer.getModules());
        this.navManager.getAvailablesPages().clear();
        modules.sort(new ModuleComparator());
        for (Module module : modules) {
            if (!NavigationRestrictions.allowAccess((NavigationElement)module) || !this.hasPagesWithAccess(module)) continue;
            viewBuilder.createModuleView(module);
            this.buildPages(module.getDefaultPageGroup(), viewBuilder);
            this.buildPageGroups(module, viewBuilder);
        }
        Component container = (Component)viewBuilder.getNavigationView();
        container.setParent(this.self);
    }

    private boolean hasPagesWithAccess(Module module) {
        boolean allowed;
        block1: {
            PageGroup pg;
            allowed = module.getDefaultPageGroup().getPages().stream().anyMatch(NavigationRestrictions::allowAccess);
            if (allowed) break block1;
            Iterator iterator = module.getPageGroups().iterator();
            while (iterator.hasNext() && !(allowed = (pg = (PageGroup)iterator.next()).getPages().stream().anyMatch(NavigationRestrictions::allowAccess))) {
            }
        }
        return allowed;
    }

    private void buildPageGroups(Module module, NavigationViewBuilder viewBuilder) {
        for (PageGroup pageGroup : module.getPageGroups()) {
            this.buildPageGroupAndSubgroups(pageGroup, viewBuilder);
        }
    }

    private void buildPageGroupAndSubgroups(PageGroup pageGroup, NavigationViewBuilder viewBuilder) {
        if (NavigationRestrictions.allowAccess((NavigationElement)pageGroup) && pageGroup.isVisible()) {
            viewBuilder.createPageGroupView(pageGroup);
            if (!pageGroup.getPageGroups().isEmpty()) {
                for (PageGroup subgroup : pageGroup.getPageGroups()) {
                    this.buildPageGroupAndSubgroups(subgroup, viewBuilder);
                }
            }
            this.buildPages(pageGroup, viewBuilder);
        }
    }

    private void buildPages(PageGroup pageGroup, NavigationViewBuilder viewBuilder) {
        Collection pages = pageGroup.getPages();
        for (Page p : pages) {
            if (!NavigationRestrictions.allowAccess((Page)p) || !p.isVisible()) continue;
            viewBuilder.createPageView(p);
            this.navManager.addAvailablePage(p);
        }
    }

    private NavigationViewBuilder createViewBuilder() {
        if (this.navigationView != null && !this.navigationView.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(this.navigationView);
                return (NavigationViewBuilder)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Navigation view builder cannot be created: " + this.navigationView, e);
            }
        }
        return new Menu();
    }
}

