/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.navigation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Label;
import org.zkoss.zul.impl.LabelElement;
import org.zkoss.zul.impl.XulElement;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.navigation.ActionPage;
import tools.dynamia.navigation.NavigationElement;
import tools.dynamia.navigation.Page;
import tools.dynamia.navigation.PageEvent;
import tools.dynamia.navigation.WorkspaceViewBuilder;
import tools.dynamia.zk.navigation.ZKNavigationManager;
import tools.dynamia.zk.util.ZKUtil;
import workspace.builders.TabPanel;

@org.springframework.stereotype.Component(value="navComposer")
@Scope(value="prototype")
public class ZKNavigationComposer
extends SelectorComposer<Component> {
    private static final long serialVersionUID = -6459772159875108265L;
    private static final NavigationElement EMPTY = new NavigationElement("", "");
    @Wire(value="#workspace")
    private XulElement workspace;
    @Wire(value=".pageTitle")
    private List<Component> pageTitles;
    @Wire(value=".pageGroupTitle")
    private List<Component> pageGroupTitles;
    @Wire(value=".moduleTitle")
    private List<Component> moduleTitles;
    private WorkspaceViewBuilder<Component> workspaceViewBuilder;
    private Component self;
    private Page desktopCurrentPage;

    public void handleEvent(PageEvent evt) {
        if (evt != null && ZKUtil.isInEventListener()) {
            String name;
            switch (name = evt.getName()) {
                case "onPageChanged": {
                    this.desktopCurrentPage = evt.getPage();
                    this.update(evt.getParams());
                    break;
                }
                case "onPageClosed": {
                    Page page = evt.getPage();
                    this.getWorkspaceViewBuilder().close(page);
                    ZKNavigationManager.getInstance().notifyPageClose(page);
                    if (page == null || !page.equals((Object)this.desktopCurrentPage)) break;
                    this.desktopCurrentPage = null;
                    break;
                }
            }
        }
    }

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.self = comp;
        ZKNavigationManager.getInstance().setCurrentDesktop(comp.getDesktop());
        ZKNavigationManager.getInstance().setCurrentComposer(this);
        this.buildWorkspace();
        this.desktopCurrentPage = ZKNavigationManager.getInstance().getCurrentPage();
        this.self.addEventListener("onHash", evt -> this.processHash(evt.getData()));
        String function = "sendMeHash('" + this.self.getUuid() + "')";
        Clients.evalJavaScript((String)function);
        if (this.desktopCurrentPage != null && !(this.desktopCurrentPage instanceof ActionPage)) {
            this.update(new HashMap<String, Object>());
        }
    }

    private void processHash(Object data) {
        if (data != null) {
            try {
                Page page = ZKNavigationManager.getInstance().findPageByPrettyVirtualPath(data.toString());
                ZKNavigationManager.getInstance().setCurrentPage(page);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Component getSelf() {
        return this.self;
    }

    void update(Map<String, Object> params) {
        if (this.desktopCurrentPage instanceof ActionPage) {
            ((ActionPage)this.desktopCurrentPage).execute();
            return;
        }
        if (this.workspaceViewBuilder != null) {
            this.workspaceViewBuilder.update(this.desktopCurrentPage, params);
        }
        if (this.desktopCurrentPage != null && !this.desktopCurrentPage.isShowAsPopup()) {
            if (ZKNavigationManager.getInstance().isAutoSyncClientURL()) {
                this.updateClientURL();
            }
            this.updatePageTitle();
        }
    }

    public void updateClientURL() {
        if (this.desktopCurrentPage.getPageGroup() != null && this.desktopCurrentPage.getPageGroup().getParentModule() != null) {
            Clients.evalJavaScript((String)("changeHash('" + this.desktopCurrentPage.getPrettyVirtualPath() + "');"));
        }
    }

    private void updatePageTitle() {
        NavigationElement page = EMPTY;
        NavigationElement pageGroup = EMPTY;
        NavigationElement module = EMPTY;
        page = this.desktopCurrentPage;
        if (this.desktopCurrentPage.getPageGroup() != null && (pageGroup = this.desktopCurrentPage.getPageGroup()) != null) {
            module = this.desktopCurrentPage.getPageGroup().getParentModule();
        }
        NavigationElement finalPage = page;
        NavigationElement finalPageGroup = pageGroup;
        NavigationElement finalModule = module;
        this.pageTitles.forEach(c -> this.setTitleValue((Component)c, finalPage));
        this.pageGroupTitles.forEach(c -> this.setTitleValue((Component)c, finalPageGroup));
        this.moduleTitles.forEach(c -> this.setTitleValue((Component)c, finalModule));
    }

    private void setTitleValue(Component titleComp, NavigationElement navigationElement) {
        if (titleComp == null || navigationElement == null) {
            return;
        }
        String text = navigationElement.getName();
        if (titleComp instanceof Label) {
            Label label = (Label)titleComp;
            label.setValue(text);
        } else if (titleComp instanceof LabelElement) {
            LabelElement element = (LabelElement)titleComp;
            element.setLabel(text);
        } else {
            titleComp.getChildren().clear();
            titleComp.appendChild((Component)new Text(text));
        }
    }

    private void buildWorkspace() throws ClassNotFoundException {
        if (this.workspace != null) {
            String builderClass = (String)this.workspace.getAttribute("builderClass");
            Class builder = null;
            builder = builderClass != null ? Class.forName(builderClass) : TabPanel.class;
            this.workspaceViewBuilder = (WorkspaceViewBuilder)BeanUtils.newInstance(builder);
            this.workspaceViewBuilder.init((Object)this.workspace);
            this.workspaceViewBuilder.build(this.desktopCurrentPage);
        }
    }

    public WorkspaceViewBuilder getWorkspaceViewBuilder() {
        return this.workspaceViewBuilder;
    }
}

