/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.navigation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import tools.dynamia.commons.Callback;
import tools.dynamia.integration.Containers;
import tools.dynamia.navigation.BaseNavigationManager;
import tools.dynamia.navigation.ModuleContainer;
import tools.dynamia.navigation.Page;
import tools.dynamia.navigation.PageEvent;
import tools.dynamia.zk.navigation.ZKNavigationComposer;
import tools.dynamia.zk.util.ZKUtil;

@Component(value="navManager")
@Scope(value="session")
public class ZKNavigationManager
extends BaseNavigationManager
implements Serializable {
    static final String QUEUE_NAME = "PageNavigationQueue";
    static final String ON_PAGE_CHANGED = "onPageChanged";
    static final String ON_PAGE_CLOSED = "onPageClosed";
    private static final long serialVersionUID = 1L;
    private ZKNavigationComposer currentComposer;
    private Desktop currentDesktop;
    private boolean autoSyncClientURL = true;
    private final List<Callback> runLaterQueue = new ArrayList<Callback>();

    public static ZKNavigationManager getInstance() {
        return (ZKNavigationManager)Containers.get().findObject(ZKNavigationManager.class);
    }

    @Autowired
    public ZKNavigationManager(ModuleContainer container) {
        super(container);
    }

    public boolean setCurrentPage(Page newPage, Map<String, Object> params) {
        boolean ok = super.setCurrentPage(newPage, params);
        if (ok) {
            this.notityComposer(new PageEvent(ON_PAGE_CHANGED, newPage, (Object)newPage, params));
        }
        return ok;
    }

    public void closePage(Page page) {
        if (page != null && page.isClosable()) {
            this.notityComposer(new PageEvent(ON_PAGE_CLOSED, page));
            this.setRawCurrentPage(this.getLastPage());
        }
    }

    private void notityComposer(PageEvent evt) {
        if (this.currentComposer != null) {
            this.currentComposer.handleEvent(evt);
        }
    }

    void notifyPageClose(Page page) {
        super.fireOnPageClose(page);
    }

    public Desktop getCurrentDesktop() {
        return this.currentDesktop;
    }

    public void setCurrentDesktop(Desktop currentDesktop) {
        this.currentDesktop = currentDesktop;
    }

    public boolean isAutoSyncClientURL() {
        return this.autoSyncClientURL;
    }

    public void setAutoSyncClientURL(boolean autoSyncClientURL) {
        this.autoSyncClientURL = autoSyncClientURL;
    }

    public void sendEvent(PageEvent evt) {
        ZKUtil.eventQueuePublish(evt.getPage().getVirtualPath(), new Event("pageEvent", null, (Object)evt));
    }

    public void onPageEvent(Page targetPage, Consumer<PageEvent> evt) {
        EventQueues.lookup((String)targetPage.getVirtualPath(), (boolean)true).subscribe(e -> {
            PageEvent pageEvent = (PageEvent)e.getData();
            if (evt != null && pageEvent != null) {
                evt.accept(pageEvent);
            }
        });
    }

    public void clearPageEvents(Page page) {
        String name;
        EventQueue queue;
        if (page != null && (queue = EventQueues.lookup((String)(name = page.getVirtualPath()), (boolean)false)) != null) {
            queue.close();
        }
    }

    public void setCurrentComposer(ZKNavigationComposer currentComposer) {
        this.currentComposer = currentComposer;
        if (ZKUtil.isInEventListener()) {
            for (Callback callback : this.runLaterQueue) {
                callback.doSomething();
            }
            this.runLaterQueue.clear();
        }
    }

    public ZKNavigationComposer getCurrentComposer() {
        return this.currentComposer;
    }

    public void runAfterCompose(Callback callback) {
        this.runLaterQueue.add(callback);
    }
}

