/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;

public class ApplicationScope
implements Scope {
    private static final String APP_SCOPE = "ZK_SPRING_APP_SCOPE";

    public Object get(String name, ObjectFactory objectFactory) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Object scopedObject;
            WebApp app = exec.getDesktop().getWebApp();
            ConcurrentHashMap appScope = (ConcurrentHashMap)app.getAttribute(APP_SCOPE);
            if (appScope == null) {
                appScope = new ConcurrentHashMap();
                app.setAttribute(APP_SCOPE, appScope);
            }
            if ((scopedObject = appScope.get(name)) == null) {
                scopedObject = objectFactory.getObject();
                appScope.put(name, scopedObject);
            }
            return scopedObject;
        }
        throw new IllegalStateException("Unable to get application scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public String getConversationId() {
        WebApp app;
        Execution exec = Executions.getCurrent();
        if (exec != null && (app = exec.getDesktop().getWebApp()) != null) {
            return app.getAppName();
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object remove(String name) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            WebApp app = exec.getDesktop().getWebApp();
            Map appScope = (Map)app.getAttribute(APP_SCOPE);
            return appScope != null ? appScope.remove(name) : null;
        }
        throw new IllegalStateException("Unable to get application scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public Object resolveContextualObject(String arg0) {
        return null;
    }
}

