/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class DesktopScope
implements Scope {
    private static final String DESKTOP_SCOPE = "ZK_SPRING_DESKTOP_SCOPE";

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Object scopedObject;
            Desktop desktop = exec.getDesktop();
            ConcurrentHashMap desktopScope = (ConcurrentHashMap)desktop.getAttribute(DESKTOP_SCOPE);
            if (desktopScope == null) {
                desktopScope = new ConcurrentHashMap();
                desktop.setAttribute(DESKTOP_SCOPE, desktopScope);
            }
            if ((scopedObject = desktopScope.get(name)) == null) {
                scopedObject = objectFactory.getObject();
                desktopScope.put(name, scopedObject);
            }
            return scopedObject;
        }
        throw new IllegalStateException("Unable to get desktop scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public String getConversationId() {
        Desktop desktop;
        Execution exec = Executions.getCurrent();
        if (exec != null && (desktop = exec.getDesktop()) != null) {
            return desktop.getId();
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object remove(String name) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Desktop desktop = exec.getDesktop();
            Map desktopScope = (Map)desktop.getAttribute(DESKTOP_SCOPE);
            return desktopScope != null ? desktopScope.remove(name) : null;
        }
        throw new IllegalStateException("Unable to get desktop scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public Object resolveContextualObject(String key) {
        return null;
    }
}

