/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class ExecutionScope
implements Scope {
    private static final String EXECUTION_SCOPE = "ZK_SPRING_EXECUTION_SCOPE";

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Object scopedObject;
            ConcurrentHashMap executionScope = (ConcurrentHashMap)exec.getAttribute(EXECUTION_SCOPE);
            if (executionScope == null) {
                executionScope = new ConcurrentHashMap();
                exec.setAttribute(EXECUTION_SCOPE, executionScope);
            }
            if ((scopedObject = executionScope.get(name)) == null) {
                scopedObject = objectFactory.getObject();
                executionScope.put(name, scopedObject);
            }
            return scopedObject;
        }
        throw new IllegalStateException("Unable to get execution scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public String getConversationId() {
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object remove(String name) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Desktop desktop = exec.getDesktop();
            Map desktopScope = (Map)desktop.getAttribute(EXECUTION_SCOPE);
            return desktopScope != null ? desktopScope.remove(name) : null;
        }
        throw new IllegalStateException("Unable to get desktop scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public Object resolveContextualObject(String key) {
        return null;
    }
}

