/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

public class PageScope
implements Scope {
    private static final String PAGE_SCOPE = "ZK_SPRING_PAGE_SCOPE";

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Object scopedObject;
            Page page = ((ExecutionCtrl)exec).getCurrentPage();
            ConcurrentHashMap pageScope = (ConcurrentHashMap)page.getAttribute(PAGE_SCOPE);
            if (pageScope == null) {
                pageScope = new ConcurrentHashMap();
                page.setAttribute(PAGE_SCOPE, pageScope);
            }
            if ((scopedObject = pageScope.get(name)) == null) {
                scopedObject = objectFactory.getObject();
                pageScope.put(name, scopedObject);
            }
            return scopedObject;
        }
        throw new IllegalStateException("Unable to get page scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public String getConversationId() {
        Page page;
        Execution exec = Executions.getCurrent();
        if (exec != null && (page = ((ExecutionCtrl)exec).getCurrentPage()) != null) {
            return page.getId();
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object remove(String name) {
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            Page page = ((ExecutionCtrl)exec).getCurrentPage();
            Map pageScope = (Map)page.getAttribute(PAGE_SCOPE);
            return pageScope != null ? pageScope.remove(name) : null;
        }
        throw new IllegalStateException("Unable to get page scope bean: " + name + ". Do you access it in ZK event listener?");
    }

    public Object resolveContextualObject(String key) {
        return null;
    }
}

