/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.util.ZKUtil;

public class Booleanbox
extends Combobox {
    private Boolean selected;
    private String trueLabel = "SI";
    private String falseLabel = "NO";

    public Booleanbox() {
        this.init();
    }

    public Booleanbox(Boolean value) {
        this.selected = value;
    }

    public void init() {
        this.setReadonly(true);
        List<BooleanWrapper> model = Arrays.asList(new BooleanWrapper(null), new BooleanWrapper(Boolean.TRUE), new BooleanWrapper(Boolean.FALSE));
        ZKUtil.fillCombobox(this, model, model.get(0), true);
        this.setItemRenderer((item, data, index) -> {
            item.setValue(data);
            item.setLabel(this.getLabel(data.value));
        });
    }

    private String getLabel(Boolean data) {
        if (data == null) {
            return "---";
        }
        if (data.booleanValue()) {
            return this.trueLabel;
        }
        return this.falseLabel;
    }

    public Boolean getSelected() {
        if (this.getSelectedItem() != null) {
            this.selected = ((BooleanWrapper)this.getSelectedItem().getValue()).value;
        }
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
        if (this.getModel() instanceof AbstractListModel) {
            AbstractListModel model = (AbstractListModel)this.getModel();
            Optional<Object> result = this.getItems().stream().filter(c -> Objects.equals(c.getValue(), selected)).map(Comboitem::getValue).findFirst();
            if (result.isPresent()) {
                model.addToSelection(result.get());
            }
        }
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String trueLabel) {
        this.trueLabel = trueLabel;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String falseLabel) {
        this.falseLabel = falseLabel;
    }

    static {
        BindingComponentIndex.getInstance().put("selected", (Class)Booleanbox.class);
        ComponentAliasIndex.getInstance().add("booleanbox", Booleanbox.class);
    }

    static class BooleanWrapper {
        Boolean value;

        public BooleanWrapper(Boolean value) {
            this.value = value;
        }
    }
}

