/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Arrays;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.impl.InputElement;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.web.util.JavaScriptUtils;
import tools.dynamia.zk.ui.Keypad;

public class Calculator
extends Keypad {
    private Number result;

    public Calculator() {
        super((InputElement)new Textbox());
        List<Keypad.Key> calculatorKeys = Arrays.asList(new Keypad.Key("%"), new Keypad.Key("/"), new Keypad.Key("x", "*"), new Keypad.Key("-"), NEW_ROW, new Keypad.Key("7"), new Keypad.Key("8"), new Keypad.Key("9"), new Keypad.Key("+", 1, 2), NEW_ROW, new Keypad.Key("4"), new Keypad.Key("5"), new Keypad.Key("6"), NEW_ROW, new Keypad.Key("1"), new Keypad.Key("2"), new Keypad.Key("3"), new Keypad.Key("=", 1, 2).setCommand((EventListener<Event>)((EventListener)e -> this.calc())).setSclass("kp-key-green"), NEW_ROW, new Keypad.Key("0", 2, 1), new Keypad.Key(","), NEW_ROW, new Keypad.Key("").setLabel("CE").setCommand((EventListener<Event>)((EventListener)e -> this.clear())), new Keypad.Key("("), new Keypad.Key(")"), new Keypad.Key("").setLabel("backspace").setIcon("fa fa-arrow-left").setCommand((EventListener<Event>)((EventListener)e -> this.backspace())));
        this.setDefaultKeys(calculatorKeys);
        this.init();
        this.getDisplayBox().setSclass("kp-display-box");
        this.getDisplayRegion().appendChild((Component)this.getDisplayBox());
        this.setWidth("400px");
        this.setHeight("400px");
        this.setValue("");
        this.getDisplayBox().addEventListener("onOK", e -> {
            this.setValue(this.getDisplayBox().getText());
            this.calc();
        });
    }

    public void calc() {
        try {
            String exp = this.getValue();
            exp = exp.replace("%", "/100");
            this.result = (Number)JavaScriptUtils.eval((String)exp);
            if (this.result != null) {
                this.setValue(String.valueOf(this.result));
                Events.postEvent((String)"onOK", (Component)this, (Object)this.result);
                this.getDisplayBox().setStyle(null);
            } else {
                this.styleError();
            }
        }
        catch (Exception e) {
            this.styleError();
        }
    }

    private void styleError() {
        this.getDisplayBox().setStyle("color: red; border-color: red");
    }

    @Override
    public void appendValue(String delta) {
        try {
            if (this.isOperation(delta)) {
                String lastChar = StringUtils.getLastCharacter((String)this.getValue());
                if (lastChar != null && !this.isOperation(lastChar)) {
                    super.appendValue(delta);
                }
            } else {
                super.appendValue(delta);
            }
        }
        catch (Exception e) {
            this.styleError();
        }
    }

    private boolean isOperation(String delta) {
        switch (delta) {
            case "+": 
            case "-": 
            case "/": 
            case "*": 
            case "%": 
            case ")": 
            case "(": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.setValue("");
        this.getDisplayBox().setStyle(null);
    }

    public Number getResult() {
        return this.result;
    }
}

