/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import org.zkoss.zul.Combobox;
import tools.dynamia.io.ImageUtil;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.util.ZKUtil;

public class Colorbox
extends Combobox {
    private static final String BACKGROUND_COLOR = "background-color: ";
    private String[] availableColors = new String[]{"white", "black", "red", "blue", "green", "yellow", "#B71C1C", "#F44336", "#E57373", "#FFCDD2", "#880E4F", "#E91E63", "#F06292", "#F8BBD0", "#4A148C", "#9C27B0", "#BA68C8", "#E1BEE7", "#311B92", "#673AB7", "#9575CD", "#D1C4E9", "#1A237E", "#3F51B5", "#7986CB", "#C5CAE9", "#0D47A1", "#2196F3", "#64B5F6", "#BBDEFB", "#1B5E20", "#4CAF50", "#81C784", "#C8E6C9", "#33691E", "#8BC34A", "#AED581", "#DCEDC8", "#F57F17", "#FFEB3B", "#FFF176", "#FFF9C4", "#E65100", "#FF9800", "#FFB74D", "#FFE0B2", "#BF360C", "#FF5722", "#FF8A65", "#FFCCBC", "#263238", "#607D8B", "#90A4AE", "#CFD8DC", "#212121", "#9E9E9E", "#E0E0E0", "#F5F5F5"};

    public Colorbox() {
        this.init();
    }

    public Colorbox(String color) {
        this.setValue(color);
        this.init();
    }

    public void setValue(String color) {
        super.setValue(color);
        this.updateBackgroundColor();
    }

    private void updateBackgroundColor() {
        if (this.getValue() != null) {
            this.setStyle(BACKGROUND_COLOR + this.getValue());
            if (ImageUtil.isDark((String)this.getValue())) {
                this.setStyle(this.getStyle() + "; color: white");
            }
        } else {
            this.setStyle(null);
        }
    }

    private void init() {
        this.setItemRenderer((item, data, index) -> {
            item.setValue(data);
            item.setLabel(data);
            item.setStyle(BACKGROUND_COLOR + data + "; text-shadow: none; text-align: right");
            item.setHeight("40px");
            if (ImageUtil.getBrightness((String)data) < 130) {
                item.setStyle(item.getStyle() + "; color: white");
            }
        });
        this.addEventListener("onSelect", e -> this.updateBackgroundColor());
        this.addEventListener("onOK", e -> this.updateBackgroundColor());
        this.initModel();
    }

    private void initModel() {
        ZKUtil.fillCombobox((Combobox)this, this.availableColors, true);
    }

    public String[] getAvailableColors() {
        return this.availableColors;
    }

    public void setAvailableColors(String[] availableColors) {
        this.availableColors = availableColors;
        this.initModel();
    }

    public void setAvailableColors(String colors) {
        if (colors != null) {
            this.setAvailableColors(colors.trim().replace(" ", "").split(","));
        }
    }

    static {
        BindingComponentIndex.getInstance().put("value", (Class)Colorbox.class);
        ComponentAliasIndex.getInstance().add(Colorbox.class);
    }
}

